% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize.R
\name{summarize_scenario}
\alias{summarize_scenario}
\alias{summarize_scenarios}
\title{Create a summary of the simulation results for a single scenario}
\usage{
summarize_scenario(simulation_result)

summarize_scenarios(simulation_results)
}
\arguments{
\item{simulation_result}{Results object for a single scenario.}

\item{simulation_results}{Simulation results dataframe.}
}
\value{
Dataframe of summary statistics.
}
\description{
Given a dataframe of raw results from \code{\link{run_simulations}}, create
summary statistics for the scenario. This is generally the most granular
level of useful data for reporting and analysis (full simulation results
are rarely directly helpful).
}
\details{
Summary stats created include:
* Mean/Min/Max/Median are calculated for loss events
* Median/Max/VaR are calculated for annual loss expected (ALE)
* Mean/Median/Max/Min are calculated for single loss expected (SLE)
* Mean percentage of threat capability exceeding difficulty on successful threat events
* Mean percentage of difficulty exceeding threat capability on defended events
* Vulnerability percentage
}
\examples{
data(mc_simulation_results)
# summarize a single scenario
summarize_scenario(mc_simulation_results[[1, "results"]])

# summarize all scenarios in a data frame
data(mc_simulation_results)
summarize_scenarios(mc_simulation_results)
}
