% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize.R
\name{summarize_iterations}
\alias{summarize_iterations}
\title{Create a summary of outcomes across all scenarios}
\usage{
summarize_iterations(simulation_result, ..., .key = "iteration")
}
\arguments{
\item{simulation_result}{Results object for a single scenario.}

\item{...}{Additional simulation result objects to summarize.}

\item{.key}{Iteration ID field}
}
\value{
Dataframe.
}
\description{
Given a dataframe of raw results from \code{\link{run_simulations}}, summarize
the individual results at a per-iteration level.
}
\details{
Summary stats created include:
* Mean/Min/Max/Median are calculated for loss events
* Median/Max/VaR are calculated for annual loss expected (ALE)
* Mean/Median/Max/Min are calculated for single loss expected (SLE)
* Mean percentage of threat capability exceeding difficulty on successful threat events
* Mean percentage of difficulty exceeding threat capability on defended events
* Vulnerability percentage
* Z-score of ALE (outliers flagged as 2 >= z-score)
}
\examples{
data(mc_simulation_results)
summarize_iterations(mc_simulation_results$results)
}
