% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RBFval.R
\name{RBFval}
\alias{RBFval}
\title{Classification of a test set by a radial basis function classifier}
\usage{
RBFval(x, param, y = NULL, calc.belief = TRUE)
}
\arguments{
\item{x}{Matrix of size n x d, containing the values of the d attributes for the test data.}

\item{param}{Neural network parameters, as provided by \code{\link{RBFfit}}.}

\item{y}{Optional vector of class labels for the test data. May be a factor, or a vector of
integers from 1 to M (number of classes).}

\item{calc.belief}{If TRUE (default), output belief functions are calculated.}
}
\value{
A list with four elements:
  \describe{
  \item{ypred}{Predicted class labels for the test data.}
  \item{err}{Test error rate (if the class label of test data has been provided).}
  \item{Prob}{Output probabilities.}
  \item{Belief}{If \code{calc.belief=TRUE}, output belief function, provided as a list
  output by function \code{\link{calcm}}.}
 }
}
\description{
\code{RBFval} classifies instances in a test set using a radial basis function classifier. Function
\code{\link{calcm}} is called for computing output belief functions. It is recommended to set
\code{calc.belief=FALSE} when the number of classes is very large, to avoid memory problems.
}
\details{
If class labels for the test set are provided, the test error rate is also returned.
}
\examples{
## Glass dataset
data(glass)
xapp<-glass$x[1:89,]
yapp<-glass$y[1:89]
xtst<-glass$x[90:185,]
ytst<-glass$y[90:185]
## Initialization
param0<-RBFinit(xapp,yapp,nproto=7)
## Training
fit<-RBFfit(xapp,yapp,param0)
## Test
val<-RBFval(xtst,fit$param,ytst)
## Confusion matrix
table(ytst,val$ypred)
}
\references{
T. Denoeux. Logistic Regression, Neural Networks and Dempster-Shafer Theory: a New Perspective.
Knowledge-Based Systems, Vol. 176, Pages 54–67, 2019.

Ling Huang, Su Ruan, Pierre Decazes and Thierry Denoeux. Lymphoma segmentation from 3D PET-CT
images using a deep evidential network. International Journal of Approximate Reasoning,
Vol. 149, Pages 39-60, 2022.
}
\seealso{
\code{\link{RBFinit}}, \code{\link{RBFfit}}, \code{\link{calcm}}
}
\author{
Thierry Denoeux.
}
