% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_event.R
\name{+.event}
\alias{+.event}
\title{Add events to an event list}
\usage{
\method{+}{event}(e1, e2)
}
\arguments{
\item{e1}{An object of class event or event_list.}

\item{e2}{An object of class event.}
}
\value{
Return an \code{event_list} object.
}
\description{
+ allows the user to add events or event_list object to an
other event or event_list objects.
}
\examples{

library(eventr)
library(magrittr)

birth_event <- event(
  id = 'first-id',
  type = 'BIRTH',
  time = '1936-11-09',
  birth_date = '1936-11-09'
)

measurement_event <- event(
  id = 'second-id',
  type = 'MEASUREMENT',
  time = '1937-11-09',
  weight = list(value = 10,2, unit = "kg"),
  height = list(value = 0,76, unit = "m")
)

death_event <- event(
  id = 'third-id',
  type = 'DEATH',
  time = '2019-05-22',
  death_date = '2019-05-22')

the_event_list <-
  birth_event +
  measurement_event +
  death_event

}
