% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_stream.R
\name{gen_stream}
\alias{gen_stream}
\title{Generates a two dimensional data stream containing events of two classes.}
\usage{
gen_stream(n, folder = NULL, sd = 1, vis = FALSE)
}
\arguments{
\item{n}{The number of files to generate. Each file consists of a 350x250 data matrix.}

\item{folder}{If this is set to a local folder, the data matrices are saved in \code{folder/data}, the images are saved in \code{folder/pics} and the event details are saved in \code{folder/summary}.  The event details are needed to obtain the class labels of events, when event extraction is done.}

\item{sd}{This specifies the seed.}

\item{vis}{If \code{TRUE}, the images are plotted.}
}
\value{
A list with following components:
  \item{\code{data}}{The data stream returned as a data frame.}
  \item{\code{details}}{A data frame containing the details of the events: their positions, class labels, etc.. .  This is needed for identifying class labels of events during event extraction.}
}
\description{
This function generates a two-dimensional data stream containing events of two classes. The data stream can be saved as separate files with images by specifying the argument \code{folder}.
}
\details{
There are events of two classes in the data matrices : A and B.  Events of class A have only one shape while events of class B have three different shapes, including class A's shape. This was motivated from a real world example. The details of events of each class are given below.
\tabular{lrr}{
Feature \tab class A   \tab class B \cr
Starting cell/pixel values \tab \code{N(4,3)} \tab \code{N(2,3)} \cr
Ending cell/pixel values  \tab \code{N(8,3)}  \tab \code{N(4,3)} \cr
Maximum age of event - shape 1 \tab \code{U(20,30)} \tab \code{U(20,30)} \cr
Maximum age of event - shape 2  \tab \code{NA}  \tab \code{U(100,150)} \cr
Maximum age of event - shape 3  \tab \code{NA} \tab \code{U(100,150)} \cr
Maximum width of event - shape 1 \tab \code{U(20,26)} \tab \code{U(20,26)} \cr
Maximum width of event - shape 2  \tab \code{NA}  \tab \code{U(30,38)} \cr
Maximum width of event - shape 3  \tab \code{NA} \tab \code{U(50,58)} \cr
}
}
\examples{
out <- gen_stream(1, sd=15)
zz <- as.matrix(out$data)
image(1:nrow(zz), 1:ncol(zz),zz, xlab="Time", ylab="Location")

}
\seealso{
\code{\link{stream_from_files}}.
}
