% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.R
\name{plot.evgam}
\alias{plot.evgam}
\title{Plot a fitted \code{evgam} object}
\usage{
\method{plot}{evgam}(x, onepage = TRUE, which = NULL, main, ask = !onepage, ...)
}
\arguments{
\item{x}{a fitted \code{evgam} object}

\item{onepage}{logical: should all plots be on one page, or on separate pages? Defaults to \code{TRUE}}

\item{which}{a vector of integers identifying which smooths to plot. The default \code{NULL} plots all smooths}

\item{main}{a character string or vector of plot titles for each plot. If not supplied default titles are used}

\item{ask}{logical: ask to show next plots if too many figures for current device?}

\item{...}{extra arguments to pass to \link[mgcv]{plot.gam}}
}
\value{
Plots representing all one- or two-dimensional smooths
}
\description{
Plot a fitted \code{evgam} object
}
\examples{

data(fremantle)
fmla_gev <- list(SeaLevel ~ s(Year, k=5, bs="cr"), ~ 1, ~ 1)
m_gev <- evgam(fmla_gev, fremantle, family = "gev")
plot(m_gev)

}
