% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fhpdcon.r
\name{fhpdcon}
\alias{fhpdcon}
\alias{lhpdcon}
\alias{nlhpdcon}
\alias{profluhpdcon}
\alias{nluhpdcon}
\alias{lhpdcon}
\alias{fhpdcon}
\alias{nlhpdcon}
\alias{profluhpdcon}
\alias{nluhpdcon}
\alias{nlhpdcon}
\alias{fhpdcon}
\alias{lhpdcon}
\alias{profluhpdcon}
\alias{nluhpdcon}
\alias{profluhpdcon}
\alias{fhpdcon}
\alias{lhpdcon}
\alias{nlhpdcon}
\alias{nluhpdcon}
\alias{nluhpdcon}
\alias{fhpdcon}
\alias{lhpdcon}
\alias{nlhpdcon}
\alias{profluhpdcon}
\title{MLE Fitting of Hybrid Pareto Extreme Value Mixture Model with Single Continuity Constraint}
\usage{
fhpdcon(x, useq = NULL, fixedu = FALSE, pvector = NULL, std.err = TRUE,
  method = "BFGS", control = list(maxit = 10000), finitelik = TRUE, ...)

lhpdcon(x, nmean = 0, nsd = 1, u = qnorm(0.9, nmean, nsd), xi = 0,
  log = TRUE)

nlhpdcon(pvector, x, finitelik = FALSE)

profluhpdcon(u, pvector, x, method = "BFGS", control = list(maxit = 10000),
  finitelik = TRUE, ...)

nluhpdcon(pvector, u, x, finitelik = FALSE)
}
\arguments{
\item{x}{vector of sample data}

\item{useq}{vector of thresholds (or scalar) to be considered in profile likelihood or
\code{NULL} for no profile likelihood}

\item{fixedu}{logical, should threshold be fixed (at either scalar value in \code{useq},
or estimated from maximum of profile likelihood evaluated at
sequence of thresholds in \code{useq})}

\item{pvector}{vector of initial values of parameters or \code{NULL} for default
values, see below}

\item{std.err}{logical, should standard errors be calculated}

\item{method}{optimisation method (see \code{\link[stats:optim]{optim}})}

\item{control}{optimisation control list (see \code{\link[stats:optim]{optim}})}

\item{finitelik}{logical, should log-likelihood return finite value for invalid parameters}

\item{...}{optional inputs passed to \code{\link[stats:optim]{optim}}}

\item{nmean}{scalar normal mean}

\item{nsd}{scalar normal standard deviation (positive)}

\item{u}{scalar threshold value}

\item{xi}{scalar shape parameter}

\item{log}{logical, if \code{TRUE} then log-likelihood rather than likelihood is output}
}
\value{
\code{\link[evmix:fhpdcon]{lhpdcon}}, \code{\link[evmix:fhpdcon]{nlhpdcon}},
and \code{\link[evmix:fhpdcon]{nluhpdcon}} give the log-likelihood,
negative log-likelihood and profile likelihood for threshold. Profile likelihood
for single threshold is given by \code{\link[evmix:fhpdcon]{profluhpdcon}}.
\code{\link[evmix:fhpdcon]{fhpdcon}} returns a simple list with the following elements

\tabular{ll}{
 \code{call}:    \tab \code{optim} call\cr
 \code{x}:       \tab data vector \code{x}\cr
 \code{init}:    \tab \code{pvector}\cr
 \code{fixedu}:  \tab fixed threshold, logical\cr
 \code{useq}:    \tab threshold vector for profile likelihood or scalar for fixed threshold\cr
 \code{nllhuseq}:  \tab profile negative log-likelihood at each threshold in useq\cr
 \code{optim}:   \tab complete \code{optim} output\cr
 \code{mle}:     \tab vector of MLE of parameters\cr
 \code{cov}:     \tab variance-covariance matrix of MLE of parameters\cr
 \code{se}:      \tab vector of standard errors of MLE of parameters\cr
 \code{rate}:    \tab \code{phiu} to be consistent with \code{\link[evd:fpot]{evd}}\cr
 \code{nllh}:    \tab minimum negative log-likelihood\cr
 \code{n}:       \tab total sample size\cr
 \code{nmean}:   \tab MLE of normal mean\cr
 \code{nsd}:     \tab MLE of normal standard deviation\cr
 \code{u}:       \tab threshold (fixed or MLE)\cr
 \code{sigmau}:  \tab MLE of GPD scale (estimated from other parameters)\cr
 \code{xi}:      \tab MLE of GPD shape\cr
 \code{phiu}:    \tab MLE of tail fraction (implied by \code{1/(1+pnorm(u,nmean,nsd))})\cr
}
}
\description{
Maximum likelihood estimation for fitting the Hybrid Pareto extreme
value mixture model, with only continuity at threshold and not necessarily
continuous in first derivative. With options for profile likelihood estimation for
threshold and fixed threshold approach.
}
\details{
The hybrid Pareto model is fitted to the entire dataset using maximum
likelihood estimation, with only continuity at threshold and not necessarily
continuous in first derivative. The estimated parameters, variance-covariance matrix
and their standard errors are automatically output.

Note that the key difference between this model (\code{hpdcon}) and the 
normal with GPD tail and continuity at threshold (\code{normgpdcon}) is that the
latter includes the rescaling of the conditional GPD component
by the tail fraction to make it an unconditional tail model. However, for the hybrid
Pareto with single continuity constraint use the GPD in it's conditional form with no
differential scaling compared to the bulk model.

See help for \code{\link[evmix:fnormgpd]{fnormgpd}} for details, type \code{help fnormgpd}. Only
the different features are outlined below for brevity.

The profile likelihood and fixed threshold approach functionality are implemented for this
version of the hybrid Pareto as it includes the threshold as a parameter. Whereas the usual
hybrid Pareto does not naturally have a threshold parameter.

The GPD \code{sigmau} parameter is now specified as function of other parameters, see 
help for \code{\link[evmix:hpdcon]{dhpdcon}} for details, type \code{help hpdcon}.
Therefore, \code{sigmau} should not be included in the parameter vector if initial values
are provided, making the full parameter vector 
(\code{nmean}, \code{nsd}, \code{u}, \code{xi}) if threshold is also estimated and
(\code{nmean}, \code{nsd}, \code{xi}) for profile likelihood or fixed threshold approach.
}
\note{
When \code{pvector=NULL} then the initial values are:
\itemize{
 \item threshold 90\% quantile (not relevant for profile likelihood for threshold or fixed threshold approaches);
 \item MLE of normal parameters assuming entire population is normal; and
 \item MLE of GPD parameters above threshold. 
}
Avoid setting the starting value for the shape parameter to
\code{xi=0} as depending on the optimisation method it may be get stuck.
}
\section{Acknowledgments}{
 See Acknowledgments in
  \code{\link[evmix:fnormgpd]{fnormgpd}}, type \code{help fnormgpd}.
}

\examples{
\dontrun{
set.seed(1)
par(mfrow = c(2, 1))

x = rnorm(1000)
xx = seq(-4, 4, 0.01)
y = dnorm(xx)

# Hybrid Pareto provides reasonable fit for some asymmetric heavy upper tailed distributions
# but not for cases such as the normal distribution

# Continuity constraint
fit = fhpdcon(x)
hist(x, breaks = 100, freq = FALSE, xlim = c(-4, 4))
lines(xx, y)
with(fit, lines(xx, dhpdcon(xx, nmean, nsd, u, xi), col="red"))
abline(v = fit$u, col = "red")
  
# No continuity constraint
fit2 = fhpd(x)
with(fit2, lines(xx, dhpd(xx, nmean, nsd, xi), col="blue"))
abline(v = fit2$u, col = "blue")
legend("topleft", c("True Density","No continuity constraint","With continuty constraint"),
  col=c("black", "blue", "red"), lty = 1)
  
# Profile likelihood for initial value of threshold and fixed threshold approach
fitu = fhpdcon(x, useq = seq(-2, 2, length = 20))
fitfix = fhpdcon(x, useq = seq(-2, 2, length = 20), fixedu = TRUE)

hist(x, breaks = 100, freq = FALSE, xlim = c(-4, 4))
lines(xx, y)
with(fit, lines(xx, dhpdcon(xx, nmean, nsd, u, xi), col="red"))
abline(v = fit$u, col = "red")
with(fitu, lines(xx, dhpdcon(xx, nmean, nsd, u, xi), col="purple"))
abline(v = fitu$u, col = "purple")
with(fitfix, lines(xx, dhpdcon(xx, nmean, nsd, u, xi), col="darkgreen"))
abline(v = fitfix$u, col = "darkgreen")
legend("topleft", c("True Density","Default initial value (90\% quantile)",
 "Prof. lik. for initial value", "Prof. lik. for fixed threshold"),
 col=c("black", "red", "purple", "darkgreen"), lty = 1)
  
# Notice that if tail fraction is included a better fit is obtained
fittailfrac = fnormgpdcon(x)

par(mfrow = c(1, 1))
hist(x, breaks = 100, freq = FALSE, xlim = c(-4, 4))
lines(xx, y)
with(fit, lines(xx, dhpdcon(xx, nmean, nsd, u, xi), col="red"))
abline(v = fit$u, col = "red")
with(fittailfrac, lines(xx, dnormgpdcon(xx, nmean, nsd, u, xi), col="blue"))
abline(v = fittailfrac$u)
legend("topright", c("Standard Normal", "Hybrid Pareto Continuous", "Normal+GPD Continuous"),
  col=c("black", "red", "blue"), lty = 1)
}

}
\references{
\url{http://www.math.canterbury.ac.nz/~c.scarrott/evmix}

\url{http://en.wikipedia.org/wiki/Normal_distribution}

\url{http://en.wikipedia.org/wiki/Generalized_Pareto_distribution}

Scarrott, C.J. and MacDonald, A. (2012). A review of extreme value
threshold estimation and uncertainty quantification. REVSTAT - Statistical
Journal 10(1), 33-59. Available from \url{http://www.ine.pt/revstat/pdf/rs120102.pdf}

Hu, Y. (2013). Extreme value mixture modelling: An R package and simulation study.
MSc (Hons) thesis, University of Canterbury, New Zealand.
\url{http://ir.canterbury.ac.nz/simple-search?query=extreme&submit=Go}

Carreau, J. and Y. Bengio (2008). A hybrid Pareto model for asymmetric fat-tailed data:
the univariate case. Extremes 12 (1), 53-76.
}
\seealso{
\code{\link[stats:Normal]{dnorm}},
 \code{\link[evmix:fgpd]{fgpd}} and \code{\link[evmix:gpd]{gpd}}
 
The \code{\link[condmixt:condmixt-package]{condmixt}} package written by one of the
original authors of the hybrid Pareto model (Carreau and Bengio, 2008) also has 
similar functions for the likelihood of the hybrid Pareto 
\code{\link[condmixt:hpareto.negloglike]{hpareto.negloglike}} and
fitting \code{\link[condmixt:hpareto.negloglike]{hpareto.fit}}.

Other hpd hpdcon normgpd normgpdcon gng gngcon
         fhpd fhpdcon fnormgpd fnormgpdcon fgng fgngcon: \code{\link{fhpd}}
}
\author{
Yang Hu and Carl Scarrott \email{carl.scarrott@canterbury.ac.nz}
}
