% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotevoTS.multivariate.R
\name{plotevoTS.multivariate}
\alias{plotevoTS.multivariate}
\title{Plots multivariate evolutionary sequence (time-series) data set}
\usage{
plotevoTS.multivariate(
  yy,
  nse = 1,
  col = NULL,
  lty = NULL,
  lwd = NULL,
  pch = NULL,
  x.label = NULL,
  y.label = NULL,
  y_min = NULL,
  y_max = NULL,
  cex.axis = NULL,
  cex.lab = NULL,
  cex.main = NULL,
  axes = NULL
)
}
\arguments{
\item{yy}{a multivariate evoTS object}

\item{nse}{the number of standard errors represented by the error bars on the plot; default is 1}

\item{col}{vector indicating colors}

\item{lty}{line type}

\item{lwd}{line width}

\item{pch}{plotting symbols}

\item{x.label}{label on x axis}

\item{y.label}{label on y axis}

\item{y_min}{minimum value of y axis}

\item{y_max}{maximum value of y axis}

\item{cex.axis}{Specify the size of the tick label numbers/text}

\item{cex.lab}{specify the size of the axis label}

\item{cex.main}{specify the size of the title text}

\item{axes}{logical, whether to plot axes or not}
}
\value{
The results are plotted.
}
\description{
Function to plot multivariate evolutionary sequence (time-series), showing trait means over time.
}
\examples{
## Generate two evolutionary sequences (time-series)
x1 <- paleoTS::sim.Stasis(60, vp=1)
x2 <- paleoTS::sim.Stasis(60, vp=1)

## Make a multivariate data set
x1_x2<-make.multivar.evoTS(x1, x2)

## Plot the data
plotevoTS.multivariate(x1_x2, y_min=-1, y_max=1)
}
\author{
Kjetil Lysne Voje
}
