% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DriftTest.R
\name{DriftTest}
\alias{DriftTest}
\title{Test drift hypothesis}
\usage{
DriftTest(means, cov.matrix, show.plot = TRUE)
}
\arguments{
\item{means}{list or array of species means being compared. array must have means in the rows.}

\item{cov.matrix}{ancestral covariance matrix for all populations}

\item{show.plot}{boolean. If TRUE, plot of eigenvalues of ancetral matrix by between group variance is showed.}
}
\value{
list of results containing:

regresion: the linear regression between the log of the eigenvalues of the ancestral matrix and the log of the between group variance (projected on the eigenvectors of the ancenstral matrix)

coefficient_CI_95: confidence intervals for the regression coefficients

log.between_group_variance: log of the between group variance (projected on the ancestral matrix eigenvectors)

log.W_eVals: log of the ancestral matrix eigenvalues

plot: plot of the regression using ggplot2
}
\description{
Given a set of covariance matrices and means for terminals, test the hypothesis
that obseved divergency is larger/smaller than expected by drift alone using a regression of
the between-group varicances on the within-group eigenvalues.
}
\note{
If the regression coefficient is significantly different to one, the null hypothesis of drift is rejected.
}
\examples{

#Input can be an array with means in each row or a list of mean vectors
means = array(rnorm(40*10), c(10, 40)) 
cov.matrix = RandomMatrix(40, 1, 1, 10)
DriftTest(means, cov.matrix)
}
\author{
Ana Paula Assis, Diogo Melo
}
\references{
Marroig, G., and Cheverud, J. M. (2004). Did natural selection or genetic drift 
produce the cranial diversification of neotropical monkeys? The American Naturalist, 163(3), 417-428. doi:10.1086/381693

Proa, M., O'Higgins, P. and Monteiro, L. R. (2013), Type I error rates for testing genetic drift with phenotypic covariance matrices: A simulation study. Evolution, 67: 185-195. doi: 10.1111/j.1558-5646.2012.01746.x
}

