% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalcEigenSd.R
\name{CalcEigenSd}
\alias{CalcEigenSd}
\title{Integration}
\usage{
CalcEigenSd(c.matrix)
}
\arguments{
\item{c.matrix}{Covariance or correlation matrix.}
}
\value{
Mean squared value of off diagonal elements of correlation matrix
}
\description{
Calculates the standardized variance of the eigenvalues of a correlation matrix. 
This is a measure of overall integration between traits.
}
\examples{
cov.matrix <- RandomMatrix(10, 1, 1, 10)
# both of the following calls are equivalent,
# CalcEigenSd() converts covariance matrices to correlation matrices internally
CalcEigenSd(cov.matrix)
CalcEigenSd(cov2cor(cov.matrix))
}
\references{
Pavlicev, Mihaela, James M. Cheverud, and Gunter P. Wagner. 2009. "Measuring Morphological Integration Using Eigenvalue Variance." Evolutionary Biology 36 (1): 157-70.
}
\seealso{
\code{\link{CalcR2}}, \code{\link{CalcICV}}, \code{\link{Flexibility}}
}
\author{
Diogo Melo
}
\keyword{correlation}
\keyword{integration}
