% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rarefaction.R
\name{PlotRarefaction}
\alias{PlotRarefaction}
\title{Plot Rarefaction analysis}
\usage{
PlotRarefaction(comparison.list, y.axis = "Statistic",
  x.axis = "Number of sampled specimens")
}
\arguments{
\item{comparison.list}{output from rarefaction functions can be used in ploting}

\item{y.axis}{Y axis lable in plot}

\item{x.axis}{Y axis lable in plot}
}
\description{
A specialized ploting function displays the results from Rarefaction functions in publication quality.
}
\examples{
\dontrun{ 
ind.data <- iris[1:50,1:4]

results.RS <- Rarefaction(ind.data, PCAsimilarity, num.reps = 5)
results.Mantel <- Rarefaction(ind.data, MatrixCor, correlation = TRUE, num.reps = 5)
results.KrzCov <- Rarefaction(ind.data, KrzCor, num.reps = 5)
results.PCA <- Rarefaction(ind.data, PCAsimilarity, num.reps = 5)

#Plotting using ggplot2
a <- PlotRarefaction(results.RS, "Random Skewers")
b <- PlotRarefaction(results.Mantel, "Mantel")
c <- PlotRarefaction(results.KrzCov, "KrzCor")
d <- PlotRarefaction(results.PCA, "PCAsimilarity")

library(cowplot)
plot_grid(a, b, c, d, labels = c("RS", 
                                 "Mantel Correlation", 
                                 "Krzanowski Correlation", 
                                 "PCA Similarity"), 
                      scale = 0.9)
}
}
\seealso{
\code{\link{BootstrapRep}}
}
\author{
Diogo Melo, Guilherme Garcia
}
\keyword{bootstap}
\keyword{rarefaction}
\keyword{repeatability}
