% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CImulen_data.R
\name{CImulen_data}
\alias{CImulen_data}
\alias{dcimulen}
\title{Confidence Interval and Sample Size for the Population Mean Value}
\usage{
CImulen_data(
  sigma,
  e = NULL,
  l = NULL,
  conf.level = c(0.9, 0.95, 0.99),
  nmin = 30,
  size = NA,
  u = c(seq(0.1, 0.4, 0.001), seq(0.6, 0.9, 0.001)),
  full = FALSE
)

dcimulen(
  sigma,
  e = NULL,
  l = NULL,
  conf.level = c(0.9, 0.95, 0.99),
  nmin = 30,
  size = NA,
  u = c(seq(0.1, 0.4, 0.001), seq(0.6, 0.9, 0.001)),
  full = FALSE
)
}
\arguments{
\item{sigma}{numeric: vector of possible variance}

\item{e}{numeric: vector of estimation errors}

\item{l}{numeric: vector of lengths of the interval}

\item{conf.level}{numeric: vector of confidence levels of the interval (default: \code{c(0.9, 0.95, 0.99)})}

\item{nmin}{numeric: minimal value of necessary observation (default: \code{30})}

\item{size}{numeric: sample size for computing a sample standard deviation. Default \code{NA} means that the solution of the estimation is used}

\item{u}{numeric: vector of quantiles used to sample the sample standard deviation (default: \code{c(seq(0.15, 0.45, 0.001), seq(0.55, 0.85, 0.001))})}

\item{full}{logical: if \code{TRUE} then a data frame with possible solution is returned, otherwise a list with a randomly chosen solution is returned (default: \code{FALSE})}
}
\value{
A data frame or a list with:
\itemize{
\item \eqn{e}: estimation error
\item \code{sigma}: population variance
\item \code{conf.level}: confidence level
\item \eqn{l}: interval length
\item \code{x}: \eqn{1-alpha/2}
\item \code{q}: \eqn{z_{1-alpha/2}}
\item \code{q2}: \eqn{z^2_{1-alpha/2}}
\item \code{n}: computed minimal sample size
\item \code{N}: the smallest integer, no less than \code{n}
\item \code{s}: sample standard deviation
}
}
\description{
Data generation for the necessary sample size of a confidence interval, for the population mean value.
Either the estimation error \eqn{e} or the length of the interval \eqn{l} must be given (\eqn{l=2*e}).
It is ensured that the computed \code{s} deviates from \code{sigma}.
}
\examples{
# one solution
CImulen_data (1:10, e=(1:10)/10)
# all solutions
mul <- CImulen_data (1:10, e=(1:10)/10, full=TRUE)
str(mul)
}
