% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assoc_data.R
\name{assoc_data}
\alias{assoc_data}
\alias{reorder_association_data}
\alias{dassoc}
\title{Optimize Frequency Table for a Target Association}
\usage{
assoc_data(
  tab,
  zero = FALSE,
  FUN = nom.cc,
  target = NA,
  tol = 0.001,
  maxit = 500,
  ...
)

reorder_association_data(
  tab,
  zero = FALSE,
  FUN = nom.cc,
  target = NA,
  tol = 0.001,
  maxit = 500,
  ...
)

dassoc(
  tab,
  zero = FALSE,
  FUN = nom.cc,
  target = NA,
  tol = 0.001,
  maxit = 500,
  ...
)
}
\arguments{
\item{tab}{table A contingency table of absolute frequencies.}

\item{zero}{logical Whether zeros are allowed in the resulting table (default: \code{FALSE}).}

\item{FUN}{function A function that computes the association or correlation from a frequency table (default: \link{nom.cc}).}

\item{target}{numeric Desired association or correlation value (default: \code{NA}, which returns the original table).}

\item{tol}{numeric Maximum allowed deviation between the achieved and target association (default: \code{0.001}).}

\item{maxit}{integer Maximum number of iterations to reach the target (default: \code{500}).}

\item{...}{Additional parameters passed to \code{FUN}.}
}
\value{
A frequency table reordered to approximate the target association. The returned object includes attributes:
\describe{
\item{\code{iterations}}{Number of iterations performed.}
\item{\code{target}}{Achieved association or correlation value.}
}
}
\description{
Reorders the entries of a frequency table to approximate a given target association or correlation.

The reordering preserves the marginal frequencies of the table. Note that the target association may
not always be achievable, especially for extreme values (e.g., +1, -1, or values near these limits).
}
\details{
The function attempts to reorder the table entries to reach the target association. If the target is extreme
(e.g., +1, -1, or values near these limits), a solution may not be possible.
If \code{attr(joint, "iterations")} equals \code{maxit}, consider increasing \code{maxit},
reducing \code{tol}, or choosing a more feasible \code{target} value:
\itemize{
\item Nominal measures: \eqn{0 \le target \le 1}
\item Ordinal measures: \eqn{-1 \le target \le +1}
}
}
\examples{
tab <- table_data(3, 2)
tab
tab2 <- assoc_data(tab, target = 0.5)
tab2

}
