% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histwidth.R
\name{histwidth}
\alias{histwidth}
\alias{width_breaks}
\alias{dhistwidth}
\title{Histogram Widths}
\usage{
histwidth(from, to, widths, dmax = 2000, maxit = 1000)

width_breaks(from, to, widths, dmax = 2000, maxit = 1000)

dhistwidth(from, to, widths, dmax = 2000, maxit = 1000)
}
\arguments{
\item{from}{numeric: start value of the range.}

\item{to}{numeric: end value of the range.}

\item{widths}{numeric: vector of possible class widths to sample from.}

\item{dmax}{numeric: maximum denominator allowed when checking fractional densities, see \code{\link[=fractions]{fractions()}}.}

\item{maxit}{integer: maximum number of iterations when attempting to find a suitable break pattern.}
}
\value{
A list containing:
\item{breaks}{Numeric vector of class boundaries.}
\item{n}{Integer vector of absolute frequencies for each class.}
\item{decimal}{Logical, \code{TRUE} if all densities are terminating decimals.}
\item{density}{Numeric vector of class densities.}
}
\description{
Generates a set of class breaks and absolute frequencies for the range from \code{from} to \code{to}.
Class widths are randomly sampled from the vector \code{widths}. The total number of classes
(\code{nb}) must be an integer multiple of \code{min(widths)}; otherwise, the function stops with an error.
If the initial frequencies (\code{n}) are too small, they can be scaled by an integer factor.
The routine also checks whether the resulting class densities are terminating decimals.
}
\examples{
l <- histwidth(1.6, 2.1, widths = c(0.05, 0.1, 0.15, 0.2))
x <- histx(l$breaks, l$n)
histdata(x, l$breaks)
# Fallback: use constant min(widths) if no valid break pattern 
# is found within max iterations
l <- histwidth(1.6, 2.1, widths=0.05, dmax=10)
str(l)
}
