\name{exams2pdf}
\alias{exams2pdf}
\alias{make_exams_write_pdf}

\title{Generation of Exams in PDF Format}

\description{
  Automatic generation of exams in PDF format.
}

\usage{
  exams2pdf(file, n = 1L, nsamp = NULL, dir = ".", template = "plain", 
    inputs = NULL, header = list(Date = Sys.Date()), name = NULL, 
    control = NULL, quiet = TRUE, edir = NULL, tdir = NULL, sdir = NULL)
  
  make_exams_write_pdf(template = "plain", inputs = NULL,
    header = list(Date = Sys.Date()), name = NULL, quiet = TRUE,
    control = NULL)
}

\arguments{
  \item{file}{character. A specification of a (list of) exercise files.}
  \item{n}{integer. The number of copies to be compiled from \code{file}.}
  \item{nsamp}{integer. The number of exercise files sampled from each
    list element of \code{file}. Sampling without replacement is used
    if possible. (Only if some element of \code{nsamp} is larger than
    the length of the corresponding element in \code{file}, sampling
    with replacement is used.)}
  \item{dir}{character. The output directory, this has to be set if
    \code{n} is greater than 1 (or \code{template} is longer than 1).
    Current working directory is used by default.}
  \item{template}{character. A specification of a LaTeX template. The package
    currently provides \code{"exam"}, \code{"solution"}, \code{"plain"}.
    For details see below.}
  \item{inputs}{character. Names of files that are needed as inputs during
    LaTeX compilation (e.g., style files, headers). Either the full path
    must be given or the file needs to be in \code{edir}.}
  \item{header}{list. A list of further options to be passed to
    the LaTeX files.}
  \item{name}{character. A name prefix for resulting exercises, by default
    chosen based on \code{template}.}
  \item{control}{A list of control arguments for the appearance of
    multiple choice results (see details).}
  \item{quiet}{logical. Should output be suppressed when calling
    \code{\link[utils]{Sweave}} and \code{\link[tools]{texi2dvi}}.}
  \item{edir}{character specifying the path of the directory in which
    the files in \code{file} are stored (see also below).}
  \item{tdir}{character specifying a temporary directory, by default
    this is chosen via \code{\link[base]{tempdir}}.}
  \item{sdir}{character specifying a directory for storing supplements, by
    default this is chosen via \code{\link[base]{tempdir}}.}
}

\details{
  \code{exams2pdf} is a proof-of-concept implementation of the new
  extensible \code{\link[exams]{xexams}} framework. It is a (slightly less
  efficient) reimplementation of the old \code{\link[exams]{exams}} function.
  
  It proceeds by using \code{make_exams_write_pdf} to set up a custom
  \code{driver$write} function on the fly before calling \code{xexams}.
  This custom driver combines each exams with the desired \code{template}
  (and \code{inputs} etc.) and then calls \code{\link[tools]{texi2dvi}}
  on the resulting LaTeX file to produce PDF output.
  
  For a single exams (\code{n = 1}) the resulting PDF is displayed on
  screen while for \code{n > 1} some output directory \code{dir} has
  to be specified where the PDF files are stored. For more details see
  the original \code{\link[exams]{exams}} function.
}

\value{
  \code{exams2pdf} returns a list of exams as generated by \code{\link[exams]{xexams}}.
  
  \code{make_exams_write_pdf} returns a function that is suitable for being
  supplied as \code{driver$write} to \code{\link[exams]{xexams}}.
}

\seealso{
  \code{\link[exams]{xexams}},
  \code{\link[exams]{exams}},
  \code{\link[tools]{texi2dvi}}
}

\examples{
## load package and enforce par(ask = FALSE)
options(device.ask.default = FALSE)

if(interactive()) {
## compile a single random exam (displayed on screen)
exams2pdf(list(
  "boxplots",
  c("tstat", "ttest", "confint"),
  c("regression", "anova"),
  "scatterplot",
  "relfreq"
))
}
}

\keyword{utilities}
