% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preview.R
\name{exclude_preview}
\alias{exclude_preview}
\title{Exclude survey previews}
\usage{
exclude_preview(
  x,
  id_col = "ResponseId",
  preview_col = "Status",
  quiet = TRUE,
  print = TRUE,
  silent = FALSE
)
}
\arguments{
\item{x}{Data frame (preferably imported from Qualtrics using \{qualtRics\}).}

\item{id_col}{Column name for unique row ID (e.g., participant).}

\item{preview_col}{Column name for survey preview.}

\item{quiet}{Logical indicating whether to print message to console.}

\item{print}{Logical indicating whether to print returned tibble to
console.}

\item{silent}{Logical indicating whether to print message to console. Note
this argument controls the exclude message not the check message.}
}
\value{
An object of the same type as \code{x} that excludes rows
that are survey previews.
For a function that checks for these rows, use \code{\link[=check_preview]{check_preview()}}.
For a function that marks these rows, use \code{\link[=mark_preview]{mark_preview()}}.
}
\description{
The \code{exclude_preview()} function removes
rows that are survey previews.
The function is written to work with data from
\href{https://www.qualtrics.com/}{Qualtrics} surveys.
}
\details{
Default column names are set based on output from the
\href{https://docs.ropensci.org/qualtRics/reference/fetch_survey.html}{\code{qualtRics::fetch_survey()}}.
The preview column in Qualtrics can be a numeric or character vector
depending on whether it is exported as choice text or numeric values.
This function works for both.

The function outputs to console a message about the number of rows
that are survey previews.
}
\examples{
# Exclude survey previews
data(qualtrics_text)
df <- exclude_preview(qualtrics_text)

# Works for Qualtrics data exported as numeric values, too
df <- qualtrics_numeric \%>\%
  exclude_preview()

# Do not print rows to console
df <- qualtrics_text \%>\%
  exclude_preview(print = FALSE)
}
\seealso{
Other preview functions: 
\code{\link{check_preview}()},
\code{\link{mark_preview}()}

Other exclude functions: 
\code{\link{exclude_duplicates}()},
\code{\link{exclude_duration}()},
\code{\link{exclude_ip}()},
\code{\link{exclude_location}()},
\code{\link{exclude_progress}()},
\code{\link{exclude_resolution}()}
}
\concept{exclude functions}
\concept{preview functions}
