% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simconf.inla.R
\name{simconf.inla}
\alias{simconf.inla}
\title{Simultaneous confidence regions for latent Gaussian models}
\usage{
simconf.inla(
  result.inla,
  stack,
  name = NULL,
  tag = NULL,
  ind = NULL,
  alpha,
  method = "NI",
  n.iter = 10000,
  verbose = 0,
  link = FALSE,
  max.threads = 0,
  seed = NULL,
  inla.sample = TRUE
)
}
\arguments{
\item{result.inla}{Result object from INLA call.}

\item{stack}{The stack object used in the INLA call.}

\item{name}{The name of the component for which to do the calculation. This
argument should only be used if a stack object is not provided, use the tag
argument otherwise.}

\item{tag}{The tag of the component in the stack for which to do the calculation.
This argument should only be used if a stack object is provided, use the name
argument otherwise.}

\item{ind}{If only a part of a component should be used in the calculations, this
argument specifies the indices for that part.}

\item{alpha}{Error probability for the region.}

\item{method}{Method for handling the latent Gaussian structure:
\itemize{
\item{'EB' }{Empirical Bayes (Gaussian approximation of posterior).}
\item{'NI' }{Numerical integration (Calculation based on the Gaussian mixture
approximation of the posterior, as calculated by INLA).}}}

\item{n.iter}{Number or iterations in the MC sampler that is used for approximating
probabilities. The default value is 10000.}

\item{verbose}{Set to TRUE for verbose mode (optional).}

\item{link}{Transform output to the scale of the data using the link function as defined in
the model estimated with INLA (default FALSE).}

\item{max.threads}{Decides the number of threads the program can use. Set to 0 for
using the maximum number of threads allowed by the system (default).}

\item{seed}{Random seed (optional).}

\item{inla.sample}{Set to TRUE if inla.posterior.sample should be used for the MC
integration.}
}
\value{
An object of class "excurobj" with elements
\item{a }{The lower bound.}
\item{b }{The upper bound.}
\item{a.marginal }{The lower bound for pointwise confidence bands.}
\item{b.marginal }{The upper bound for pointwise confidence bands.}
}
\description{
\code{simconf.inla} is used for calculating simultaneous confidence regions
for latent Gaussian models estimated using \code{INLA}.
}
\details{
See \code{\link{simconf}} for details.
}
\note{
This function requires the \code{INLA} package, which is not a CRAN package.
See \url{https://www.r-inla.org/download-install} for easy installation instructions.
}
\examples{
\dontrun{
if (require.nowarnings("INLA")) {
n <- 10
x <- seq(0, 6, length.out=n)
y <- sin(x) + rnorm(n)
mu <- 1:n
result <- inla(y ~ 1 + f(mu, model='rw2'),
               data=list(y=y, mu=mu), verbose=FALSE,
               control.compute = list(config=TRUE,
                                      return.marginals.predictor = TRUE),
               num.threads = "1:1")

res <- simconf.inla(result, name='mu', alpha = 0.05, max.threads = 1)

plot(result$summary.random$mu$mean,ylim=c(-2,2))
lines(res$a)
lines(res$b)
lines(res$a.marginal,col="2")
lines(res$b.marginal,col="2")
}}
}
\references{
Bolin et al. (2015) \emph{Statistical prediction of global sea level
from global temperature}, Statistica Sinica, vol 25, pp 351-367.

Bolin, D. and Lindgren, F. (2018), \emph{Calculating Probabilistic Excursion Sets and Related Quantities Using excursions}, Journal of Statistical Software, vol 86, no 1, pp 1-20.
}
\seealso{
\code{\link{simconf}}, \code{\link{simconf.mc}}, \code{\link{simconf.mixture}}
}
\author{
David Bolin \email{davidbolin@gmail.com}
}
