% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choose_b.R
\name{plot.choose_b}
\alias{plot.choose_b}
\title{Plot block length diagnostic for the semiparametric maxima estimator}
\usage{
\method{plot}{choose_b}(x, y, ..., estimator = c("N2015", "BB2018"),
  maxima = c("sliding", "disjoint"))
}
\arguments{
\item{x}{an object of class \code{c("choose_b", "exdex")}, a result of a
call to \code{\link{choose_b}}.}

\item{y}{Not used.}

\item{...}{Additional arguments passed on to
\code{\link[graphics]{matplot}} and/or \code{\link[graphics]{axis}}.}

\item{estimator}{Choice of estimator: \code{"N2015"} for Northrop (2015),
\code{"BB2018"} for Berghaus and Bucher (2018).
See \code{\link{spm}} for details.}

\item{maxima}{Should the estimator be based on sliding or disjoint maxima?}
}
\value{
Nothing is returned.
}
\description{
\code{plot} method for objects inheriting from class \code{"choose_b"},
returned from \code{\link{choose_b}}
}
\details{
Produces a simple diagnostic plot to aid the choice of block
  length \eqn{b} based on the object returned from \code{\link{choose_b}}.
  Estimates of \eqn{b} and approximate \code{conf}\% confidence intervals
  are plotted against the value of \eqn{b} used to produce each estimate.
  The type of confidence interval is determined by the arguments
  \code{interval_type}, \code{conf_scale} and \code{type} provided in the
  call to \code{\link{choose_b}}.
}
\section{Examples}{

See the examples in \code{\link{choose_b}}.
}

\references{
Northrop, P. J. (2015) An efficient semiparametric maxima
estimator of the extremal index. \emph{Extremes} \strong{18}(4), 585-603.
\url{https://doi.org/10.1007/s10687-015-0221-5}

Berghaus, B., Bucher, A. (2018) Weak convergence of a pseudo
maximum likelihood estimator for the extremal index. \emph{Ann. Statist.}
\strong{46}(5), 2307-2335. \url{https://doi.org/10.1214/17-AOS1621}
}
\seealso{
\code{\link{choose_b}}.
}
