% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDifferences.R
\name{plotDifferences}
\alias{plotDifferences}
\title{Plot the fold change of fluxes between two models into a bipartite graph.}
\usage{
plotDifferences(model1, model2, ...)
}
\arguments{
\item{model1}{A valid model for the \code{'sybil'} package.}

\item{model2}{A valid model for the \code{'sybil'} package. Must have the same reactions (reaction number and reaction identifiers) as \code{"model1"} with different restrictions.}

\item{...}{Additional arguments affecting the plot}
}
\description{
This functions calculates the fold change \code{"(fluxModel2/fluxModel1)-1"} for the fluxes of two given metabolic models and plot it into a bipartite graph. Vertex size is assigned proportional to the fold change; if fold change is positive, green color is assigned, in contrary case, red color is assigned.
}
\examples{
\dontrun{
# Loading a model
library("sybil")
library("Biobase")
data("Ec_core")

# Generating expressionSets
expressionData <- matrix(data = runif(3*length(Ec_core@allGenes),min = 1,max = 100),
                         nrow = length(Ec_core@allGenes),
                         dimnames = list(c(Ec_core@allGenes),c()))
expressionData <- ExpressionSet(assayData = expressionData)

# Applying exp2flux
Ec_coreGE <- exp2flux(model = Ec_core,
                      expression = expressionData,
                      missing = "mean")

# Plotting Differences
plotDifferences(model1 = Ec_core, 
                model2 = Ec_coreGE)
                }
}
\author{
Daniel Camilo Osorio <dcosorioh@unal.edu.co>
}
\keyword{between}
\keyword{differences}
\keyword{flux}
\keyword{model}
\keyword{plot}
\keyword{scenarios}
\keyword{two}

