/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.ZeroException;
import org.apache.commons.math3.linear.AnyMatrix;
import org.apache.commons.math3.linear.RealMatrixChangingVisitor;
import org.apache.commons.math3.linear.RealMatrixPreservingVisitor;
import org.apache.commons.math3.linear.RealVector;

public interface RealMatrix
extends AnyMatrix {
    public RealMatrix createMatrix(int var1, int var2);

    public RealMatrix copy();

    public RealMatrix add(RealMatrix var1);

    public RealMatrix subtract(RealMatrix var1);

    public RealMatrix scalarAdd(double var1);

    public RealMatrix scalarMultiply(double var1);

    public RealMatrix multiply(RealMatrix var1);

    public RealMatrix preMultiply(RealMatrix var1);

    public RealMatrix power(int var1);

    public double[][] getData();

    public double getNorm();

    public double getFrobeniusNorm();

    public RealMatrix getSubMatrix(int var1, int var2, int var3, int var4);

    public RealMatrix getSubMatrix(int[] var1, int[] var2);

    public void copySubMatrix(int var1, int var2, int var3, int var4, double[][] var5);

    public void copySubMatrix(int[] var1, int[] var2, double[][] var3);

    public void setSubMatrix(double[][] var1, int var2, int var3) throws ZeroException, OutOfRangeException, DimensionMismatchException, NullArgumentException;

    public RealMatrix getRowMatrix(int var1);

    public void setRowMatrix(int var1, RealMatrix var2);

    public RealMatrix getColumnMatrix(int var1);

    public void setColumnMatrix(int var1, RealMatrix var2);

    public RealVector getRowVector(int var1);

    public void setRowVector(int var1, RealVector var2);

    public RealVector getColumnVector(int var1);

    public void setColumnVector(int var1, RealVector var2);

    public double[] getRow(int var1);

    public void setRow(int var1, double[] var2);

    public double[] getColumn(int var1);

    public void setColumn(int var1, double[] var2);

    public double getEntry(int var1, int var2);

    public void setEntry(int var1, int var2, double var3);

    public void addToEntry(int var1, int var2, double var3);

    public void multiplyEntry(int var1, int var2, double var3);

    public RealMatrix transpose();

    public double getTrace();

    public double[] operate(double[] var1);

    public RealVector operate(RealVector var1);

    public double[] preMultiply(double[] var1);

    public RealVector preMultiply(RealVector var1);

    public double walkInRowOrder(RealMatrixChangingVisitor var1);

    public double walkInRowOrder(RealMatrixPreservingVisitor var1);

    public double walkInRowOrder(RealMatrixChangingVisitor var1, int var2, int var3, int var4, int var5);

    public double walkInRowOrder(RealMatrixPreservingVisitor var1, int var2, int var3, int var4, int var5);

    public double walkInColumnOrder(RealMatrixChangingVisitor var1);

    public double walkInColumnOrder(RealMatrixPreservingVisitor var1);

    public double walkInColumnOrder(RealMatrixChangingVisitor var1, int var2, int var3, int var4, int var5);

    public double walkInColumnOrder(RealMatrixPreservingVisitor var1, int var2, int var3, int var4, int var5);

    public double walkInOptimizedOrder(RealMatrixChangingVisitor var1);

    public double walkInOptimizedOrder(RealMatrixPreservingVisitor var1);

    public double walkInOptimizedOrder(RealMatrixChangingVisitor var1, int var2, int var3, int var4, int var5);

    public double walkInOptimizedOrder(RealMatrixPreservingVisitor var1, int var2, int var3, int var4, int var5);
}

