% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5.1-fs.R
\docType{methods}
\name{fs}
\alias{fs}
\alias{fsANOVA}
\alias{fsANOVA,ExprsArray-method}
\alias{fsEbayes}
\alias{fsEbayes,ExprsBinary-method}
\alias{fsInclude}
\alias{fsInclude,ExprsBinary-method}
\alias{fsMrmre}
\alias{fsMrmre,ExprsBinary-method}
\alias{fsNULL}
\alias{fsNULL,ExprsArray-method}
\alias{fsPathClassRFE}
\alias{fsPathClassRFE,ExprsBinary-method}
\alias{fsPrcomp}
\alias{fsPrcomp,ExprsBinary-method}
\alias{fsSample}
\alias{fsSample,ExprsArray-method}
\alias{fsStats}
\alias{fsStats,ExprsBinary-method}
\title{Perform Feature Selection}
\usage{
fsSample(object, top = 0, ...)

fsNULL(object, top = 0, ...)

fsANOVA(object, top = 0, ...)

fsInclude(object, top = 0, include)

fsStats(object, top = 0, ...)

fsPrcomp(object, top = 0, ...)

fsPathClassRFE(object, top = 0, ...)

fsEbayes(object, top = 0, ...)

fsMrmre(object, top = 0, ...)

\S4method{fsSample}{ExprsArray}(object, top = 0, ...)

\S4method{fsNULL}{ExprsArray}(object, top = 0, ...)

\S4method{fsInclude}{ExprsBinary}(object, top = 0, include)

\S4method{fsANOVA}{ExprsArray}(object, top = 0, ...)

\S4method{fsStats}{ExprsBinary}(object, top = 0, how = c("t.test",
  "ks.test"), ...)

\S4method{fsPrcomp}{ExprsBinary}(object, top = 0, ...)

\S4method{fsPathClassRFE}{ExprsBinary}(object, top = 0, ...)

\S4method{fsEbayes}{ExprsBinary}(object, top = 0, ...)

\S4method{fsMrmre}{ExprsBinary}(object, top = 0, ...)
}
\arguments{
\item{object}{Specifies the \code{ExprsArray} object to undergo feature selection.}

\item{top}{A numeric scalar or character vector. A numeric scalar indicates
the number of top features that should undergo feature selection. A character vector
indicates specifically which features by name should undergo feature selection.
Set \code{top = 0} to include all features. A numeric vector can also be used
to indicate specific features by location, similar to a character vector.}

\item{...}{Arguments passed to the respective wrapped function.}

\item{include}{A character vector. The names of features to rank above all others.
This preserves the feature order otherwise. Argument for \code{fsInclude} only.}

\item{how}{A character string. Toggles between the sub-routines "t.test" and
"ks.test". Argument for \code{fsStats} only.}
}
\value{
Returns an \code{ExprsArray} object.
}
\description{
A collection of functions to select features.
}
\details{
Considering the high-dimensionality of most genomic datasets, it is prudent and often necessary
 to prioritize which features to include during classifier construction. Although there exists
 many feature selection methods, this package provides wrappers for some of the most popular ones.
 Each wrapper (1) pre-processes the \code{ExprsArray} input, (2) performs the feature selection,
 and (3) returns an \code{ExprsArray} output with an updated feature selection history.
 You can use, in tandem, any number of feature selection methods, and in any order.

For all feature selection methods, \code{@preFilter} and \code{@reductionModel} stores the
 feature selection and dimension reduction history, respectively. This history gets passed
 along to prepare the test or validation set during model deployment, ensuring that these
 sets undergo the same feature selection and dimension reduction as the training set.

Under the scenarios where users plan to apply multiple feature selection or dimension
 reduction steps, the \code{top} argument manages which features (e.g., gene expression values)
 to send through each feature selection or dimension reduction procedure. For \code{top},
 a numeric scalar indicates the number of top features to use, while a character vector
 indicates specifically which features to use. In this way, the user sets which features
 to feed INTO the \code{fs} method (NOT which features the user expects OUT). The example
 below shows how to apply dimension reduction to the top 50 features as selected by the
 Student's t-test. Set \code{top = 0} to pass all features through an \code{fs} method.

Note that not all feature selection methods will generalize to multi-class data.
 A feature selection method will fail when applied to an \code{ExprsMulti} object
 unless that feature selection method has an \code{ExprsMulti} method.

Note that \code{fsMrmre} crashes when supplied a very large \code{feature_count} argument
 owing to its implementation in the imported package \code{mRMRe}.
}
\section{Methods (by generic)}{

\code{fsSample:} Method to perform random feature selection using base::sample.


\code{fsNULL:} Method to perform a NULL feature selection and return input unaltered.


\code{fsInclude:} Method to rank explicitly stated features above all others.


\code{fsANOVA:} Method to perform ANOVA feature selection using stats::aov.


\code{fsStats:} Method to perform statistics based feature selection using stats::t.test and others.


\code{fsPrcomp:} Method to perform principal components analysis using stats::prcomp.


\code{fsPathClassRFE:} Method to perform SVM-RFE feature selection using pathClass::fit.rfe.


\code{fsEbayes:} Method to perform empiric Bayes feature selection using limma::ebayes.


\code{fsMrme:} Method to perform mRMR feature selection using mRMRe::mRMR.classic.
}
\examples{
\dontrun{
library(golubEsets)
data(Golub_Merge)
array <- arrayEset(Golub_Merge, colBy = "ALL.AML", include = list("ALL", "AML"))
array <- modFilter(array, 20, 16000, 500, 5) # pre-filter Golub ala Deb 2003
array <- modTransform(array) # lg transform
array <- modNormalize(array, c(1, 2)) # normalize gene and subject vectors
arrays <- splitSample(array, percent.include = 67)
array.train <- fsStats(arrays[[1]], top = 0, how = "t.test")
array.train <- fsPrcomp(array.train, top = 50)
mach <- buildSVM(array.train, top = 5, kernel = "linear", cost = 1)
}
}
\seealso{
\code{\link{fs}}\cr
\code{\link{build}}\cr
\code{\link{doMulti}}\cr
\code{\link{exprso-predict}}\cr
\code{\link{plCV}}\cr
\code{\link{plGrid}}\cr
\code{\link{plGridMulti}}\cr
\code{\link{plMonteCarlo}}\cr
\code{\link{plNested}}
}

