% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/7.2-plGrid.R
\name{plGrid}
\alias{plGrid}
\title{Perform High-Throughput Machine Learning}
\usage{
plGrid(array.train, array.valid = NULL, top, how, fold = 10,
  aucSkip = FALSE, verbose = TRUE, ...)
}
\arguments{
\item{array.train}{Specifies the \code{ExprsArray} object to use as training set.}

\item{array.valid}{Specifies the \code{ExprsArray} object to use as validation set.}

\item{top}{A numeric scalar or character vector. A numeric scalar indicates
the number of top features that should undergo feature selection. A character vector
indicates specifically which features by name should undergo feature selection.
Set \code{top = 0} to include all features. Note that providing a numeric vector
for the \code{top} argument will have \code{plGrid} search across multiple
top features. However, by providing a list of numeric vectors as the \code{top}
argument, the user can force the default handling of numeric vectors.}

\item{how}{A character string. Specifies the \code{\link{build}} method to iterate.}

\item{fold}{A numeric scalar. Specifies the number of folds for cross-validation.
Set \code{fold = 0} to perform leave-one-out cross-validation. Argument passed
to \code{\link{plCV}}. Set \code{fold = NULL} to skip cross-validation altogether.}

\item{aucSkip}{A logical scalar. Argument passed to \code{\link{calcStats}}.}

\item{verbose}{A logical scalar. Argument passed to \code{\link{exprso-predict}}.}

\item{...}{Arguments passed to the \code{how} method. Unlike the \code{build} method,
\code{plGrid} allows multiple parameters for each argument, supplied as a vector.
See Details.}
}
\value{
An \code{\link{ExprsPipeline-class}} object.
}
\description{
Trains and deploys models across a vast parameter search space.
}
\details{
\code{plGrid} will \code{\link{build}} and \code{\link{exprso-predict}} for
 each combination of parameters provided as additional arguments (\code{...}).
 When using \code{plGrid}, supplying a numeric vector as the \code{top}
 argument will train and deploy a model of each mentioned size for
 each combination of parameters provided in \code{...}. To skip validation set
 prediction, use \code{array.valid = NULL}. Either way, this function returns an
 \code{\link{ExprsPipeline-class}} object which contains a summary of the build
 parameters and the models themselves. The argument \code{fold} controls
 cross-validation via \code{\link{plCV}}.
}
