% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html_table.R
\name{htmlTable.etable}
\alias{htmlTable.etable}
\alias{htmlTable.with_caption}
\alias{htmlTable.list}
\alias{knit_print.etable}
\alias{knit_print.with_caption}
\alias{repr_html.etable}
\alias{repr_html.with_caption}
\alias{repr_text.etable}
\title{Outputting HTML tables in RStudio viewer/R Notebooks}
\usage{
\method{htmlTable}{etable}(x, digits = get_expss_digits(),
  escape.html = FALSE, ..., row_groups = TRUE)

\method{htmlTable}{with_caption}(x, digits = get_expss_digits(),
  escape.html = FALSE, ..., row_groups = TRUE)

\method{htmlTable}{list}(x, gap = "<br>", ...)

knit_print.etable(x, digits = get_expss_digits(), escape.html = FALSE,
  ...)

knit_print.with_caption(x, digits = get_expss_digits(),
  escape.html = FALSE, ...)

repr_html.etable(obj, digits = get_expss_digits(), escape.html = FALSE,
  ...)

repr_html.with_caption(obj, digits = get_expss_digits(),
  escape.html = FALSE, ...)

repr_text.etable(obj, digits = get_expss_digits(), ...)
}
\arguments{
\item{x}{a data object of class 'etable' - result of \link{fre}/\link{cro} and etc.}

\item{digits}{integer By default, all numeric columns are rounded to one digit after
decimal separator. Also you can set this argument by setting option 'expss.digits'
- for example, \code{expss_digits(2)}. If it is NA than all
numeric columns remain unrounded.}

\item{escape.html}{logical: should HTML characters be escaped? Defaults to FALSE.}

\item{...}{further parameters for \link[htmlTable]{htmlTable}.}

\item{row_groups}{logical Should we create row groups? TRUE by default.}

\item{gap}{character Separator between tables if we output list of
tables. By default it is line break '<br>'.}

\item{obj}{a data object of class 'etable' - result of \link{fre}/\link{cro} and etc.}
}
\value{
Returns a string of class htmlTable
}
\description{
This is method for rendering results of \link{fre}/\link{cro}/\link{tables}
in Shiny/RMarkdown/Jupyter notebooks and etc. For detailed description of
function and its arguments see \link[htmlTable]{htmlTable}. You can pack your
tables in the list and render them all simultaneously. See examples. You may
be interested in \code{expss_output_viewer()} for automatical rendering
tables in the RStudio viewer or  \code{expss_output_rnotebook()} for
rendering in the R notebooks. See \link{expss.options}. \code{repr_html} is
method for rendering table in the Jupyter notebooks and \code{knit_print} is
method for rendering table in the \code{knitr} HTML-documents. Jupyter
notebooks and \code{knitr} documents are supported automatically but in the R
notebooks it is needed to set output to notebook via
\code{expss_output_rnotebook()}.
}
\examples{
\dontrun{ 
data(mtcars)
mtcars = apply_labels(mtcars,
                      mpg = "Miles/(US) gallon",
                      cyl = "Number of cylinders",
                      disp = "Displacement (cu.in.)",
                      hp = "Gross horsepower",
                      drat = "Rear axle ratio",
                      wt = "Weight (1000 lbs)",
                      qsec = "1/4 mile time",
                      vs = "Engine",
                      vs = c("V-engine" = 0,
                             "Straight engine" = 1),
                      am = "Transmission",
                      am = c("Automatic" = 0,
                             "Manual"=1),
                      gear = "Number of forward gears",
                      carb = "Number of carburetors"
)

expss_output_viewer()
mtcars \%>\% 
     tab_cols(total(), am \%nest\% vs) \%>\% 
     tab_cells(mpg, hp) \%>\% 
     tab_stat_mean() \%>\% 
     tab_cells(cyl) \%>\% 
     tab_stat_cpct() \%>\% 
     tab_pivot() \%>\% 
     set_caption("Table 1. Some variables from mtcars dataset.")
     
# several tables in a list
mtcars \%>\% 
    calc(list(
        cro_cpct(list(am, vs, cyl), list(total(), am)) \%>\% set_caption("Table 1. Percent."),   
        cro_mean_sd_n(list(mpg, hp, qsec), list(total(), am)) \%>\% set_caption("Table 2. Means.")
    )) \%>\% 
    htmlTable()
     
expss_output_default()   
 
}
}
