% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_es.R
\name{tbl_es-class}
\alias{tbl_es-class}
\alias{tbl_es}
\title{\code{tbl_es} class}
\description{
The \code{tbl_es} class is a subclass of \code{\link[dtplyr:lazy_dt]{dtplyr::lazy_dt()}} created in order to
store attributes for experience studies. The colloquial term 'expstudy'
refers to a \code{\link[=lazy_dt]{lazy_dt()}} that has the \code{tbl_es} subclass.
}
\section{Properties of \code{tbl_es}}{

\itemize{
\item Attributes that store variable names used for key metric calculations:
\itemize{
\item \code{actuals}: the observed variable (or variables) within the experience
study (e.g., actual lapse counts for a lapse study).
\item \code{expecteds}: the expected variable (or variables) within the experience
study (e.g., expected number of deaths for a mortality study).
\item \code{exposures}: the exposure variable (or variables) within the experience
study. This will be the time the records spans in years (or within (0, 1)
for records covering less than a year).
\item \code{variances}: optional, the variance variable (or variables) within the
experience study. This may not be available for all studies, thus can be
omitted. Variance is used for the credibility metric.
}
\item An additional (optional) \code{keys} attribute that can uniquely describe every
record within the experience study. This typically is policy number and a
measure of time, such as annual or monthly duration. Can be omitted, but
providing enables quicker binary searches within the \code{\link[dtplyr:lazy_dt]{dtplyr::lazy_dt()}}.
For more information, refer to the \link{data.table} vignette:
\code{vignette('datatable-keys-fast-subset', package = 'data.table')}.
}
}

\section{Behavior of \code{tbl_es}}{


A \code{tbl_es} behaves the same as a \code{\link[dtplyr:lazy_dt]{dtplyr::lazy_dt()}} only differing by
retaining the attributes listed above. This saves time in routine, repetitive
coding, leading to increased time for analysis.
}

\seealso{
\link[dtplyr:lazy_dt]{dtplyr::lazy_dt}
}
