% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fun_testPaired.R
\name{testPaired}
\alias{testPaired}
\title{Paired Wilcoxon statistical test}
\usage{
testPaired(e, output, rankOrder = "max", alpha = 0.05)
}
\arguments{
\item{e}{Input experiment}

\item{output}{The output for which the tet will be performed.}

\item{rankOrder}{The optimization strategy, can be either maximizing "max"
or minimizing "min" the target output variable.}

\item{alpha}{The significance level used for the whole testing procedure.}
}
\value{
a testPaired object
}
\description{
This function performs a Wilcoxon paired test to compare the methods of an
experiment consisting exactly on two of them. If more methods are present,
then a multiple comparison test must be applied.
}
\examples{
# First we create an experiment from the wekaExperiment problem and prepare
# it to apply the test, we must subset it to only two methods:
experiment <- expCreate(wekaExperiment, name="test", parameter="fold")
experiment <- expSubset(experiment, list(method = c("J48", "NaiveBayes")))
experiment <- expSubset(experiment, list(featureSelection = c("no")))
experiment <- expReduce(experiment, "fold", mean)
experiment <- expInstantiate(experiment, removeUnary=TRUE)

# Then we perform a Wilcoxon test procedure
test <- testPaired(experiment, "accuracy", "max")

summary(test)
}

