/*
 * Decompiled with CFR 0.152.
 */
package org.extratrees;

import java.util.ArrayList;
import java.util.Set;
import org.extratrees.BinaryTree;
import org.extratrees.ExtraTrees;
import org.extratrees.Matrix;
import org.extratrees.QuantileBinaryTree;
import org.extratrees.QuickSelect;

public class QuantileExtraTrees
extends ExtraTrees {
    public QuantileExtraTrees(Matrix matrix, double[] dArray) {
        super(matrix, dArray);
    }

    public double[] getQuantiles(Matrix matrix, double d) {
        double[] dArray = new double[matrix.nrows];
        ArrayList<Double> arrayList = new ArrayList<Double>(this.trees.size());
        double[] dArray2 = new double[matrix.ncols];
        for (int i = 0; i < matrix.nrows; ++i) {
            matrix.copyRow(i, dArray2);
            this.getLeafValues(dArray2, arrayList);
            dArray[i] = QuickSelect.quickSelect(arrayList, d);
        }
        return dArray;
    }

    public void getLeafValues(double[] dArray, ArrayList<Double> arrayList) {
        arrayList.clear();
        for (BinaryTree binaryTree : this.trees) {
            QuantileBinaryTree quantileBinaryTree = (QuantileBinaryTree)binaryTree.getLeaf(dArray);
            arrayList.addAll(quantileBinaryTree.values);
        }
    }

    @Override
    public BinaryTree makeLeaf(int[] nArray, Set<Integer> set) {
        QuantileBinaryTree quantileBinaryTree = new QuantileBinaryTree();
        quantileBinaryTree.value = 0.0;
        quantileBinaryTree.nSuccessors = nArray.length;
        quantileBinaryTree.tasks = set;
        quantileBinaryTree.values = new ArrayList(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            quantileBinaryTree.value += this.output[nArray[i]];
            quantileBinaryTree.values.add(this.output[nArray[i]]);
        }
        quantileBinaryTree.value /= (double)nArray.length;
        return quantileBinaryTree;
    }
}

