% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extr_pubchem.R
\name{extr_pubchem_ghs}
\alias{extr_pubchem_ghs}
\title{Extract GHS Codes from PubChem}
\usage{
extr_pubchem_ghs(casrn)
}
\arguments{
\item{casrn}{Character vector of CAS Registry Numbers (CASRN).}
}
\value{
A dataframe containing GHS information.
}
\description{
This function extracts GHS (Globally Harmonized System) codes from PubChem. It relies on the \code{webchem} package to interact with PubChem.
}
\examples{
\donttest{
extr_pubchem_ghs(casrn = c("50-00-0", "64-17-5"))
}
}
\seealso{
\href{https://pubchem.ncbi.nlm.nih.gov/}{PubChem}
}
