% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/q_weighted.R
\name{q_weighted}
\alias{q_weighted}
\title{Compute weighted averages of quantile estimates}
\usage{
q_weighted(quant, weights = distLweights(quant, ...), onlyc = FALSE, ...)
}
\arguments{
\item{quant}{Data.frame as in \code{\link{distLquantile}} output.}

\item{weights}{Data.frame as in \code{\link{distLweights}} output.}

\item{onlyc}{Logical: only return custom weighted quantile estimates as
a vector? Useful to add those to existing results. See examples.
DEFAULT: FALSE}

\item{\dots}{Arguments passed to \code{\link{distLweights}} like
weightc, onlydn=FALSE. order will be ignored, as
q_weighted only adds/changes the rows weighted*.}
}
\value{
data.frame with rows "weighted*" added.
}
\description{
Compute weighted averages of quantile estimates
}
\examples{
x <- data.frame(A=1:5, RMSE=runif(5))
distLweights(x, onlydn=FALSE)

q_weighted(x,  onlydn=FALSE)
q_weighted(x,  distLweights(x, weightc=c("1"=3, "3"=5), order=FALSE, onlydn=FALSE)  )

x <- rexp(190)
d <- distLquantile(x)
d2 <- q_weighted(d)
stopifnot(all(d==d2, na.rm=TRUE))

# fast option for adding custom weighted estimates:
cw <- runif(17)
names(cw) <- c("exp", "gam", "gev", "glo", "gno", "gpa", "gum", "kap", "lap",
               "ln3", "nor", "pe3", "ray", "revgum", "rice", "wak", "wei")
dw <- distLweights(d, weightc=cw)
qw1 <- q_weighted(d, weightc=cw); qw1
qw2 <- q_weighted(d, weights=dw); qw2
stopifnot(all(qw1==qw2, na.rm=TRUE))
q_weighted(d, weights=dw, onlyc=TRUE)
q_weighted(d, weights=data.frame(weightc=cw), onlyc=TRUE)

\dontrun{ # time consuming
system.time(pbreplicate(5000, q_weighted(d, weightc=cw)))             # 8.5 secs
system.time(pbreplicate(5000, q_weighted(d, weights=dw, onlyc=TRUE))) # 0.8 secs
}

}
\seealso{
\code{\link{distLquantile}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Dec 2016
}
\keyword{distribution}
