% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sb_cv.R
\name{sb_cv}
\alias{sb_cv}
\title{Panel Sieve Bootstrap Critical Values}
\usage{
sb_cv(data, minw, lag = 0, nboot = 1000)
}
\arguments{
\item{data}{A univariate or multivariate numeric ts object, data.frame or matrix.
The estimation process cannot handle NA values.}

\item{minw}{A positive integer. The minimum window size, which defaults to
\eqn{(0.01 + 1.8/\sqrt(T))*T}{(0.01 + 1.8 / \sqrtT)*T}.}

\item{lag}{A non-negative integer. The lag of the Augmented Dickey-Fuller regression.}

\item{nboot}{A positive integer indicating the number of bootstraps. Default is 1000 repetitions.}
}
\value{
A list that contains the panel critical values for BSADF and GSADF
t-statistics.
}
\description{
\code{sb_cv} computes p-values for the panel recursive unit root test using
the sieve bootstrap procedure outlined in Pavlidis et al. (2016)
}
\examples{
\donttest{

# Simulate bubble processes
set.seed(124)
pdta <- cbind(sim_dgp1(100), sim_dgp1(100), sim_div(100), sim_div(100), sim_div(100))

# Panel critical vales should have the same lag length with the estimation
sb <- sb_cv(pdta, lag = 1)

pdta \%>\%
  radf(lag = 1) \%>\%
  summary(cv = sb)

pdta \%>\%
  radf(lag = 1) \%>\%
  autoplot(cv = sb)
}
}
\references{
Pavlidis, E., Yusupova, A., Paya, I., Peel, D., Martínez-García,
E., Mack, A., & Grossman, V. (2016). Episodes of exuberance in housing markets:
in search of the smoking gun. The Journal of Real Estate Finance and Economics, 53(4), 419-449.
}
\seealso{
\code{\link{mc_cv}} for Monte Carlo critical values and
\code{\link{wb_cv}} for Wild Bootstrapped critical values
}
