% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/va_methods.R
\name{va_methods}
\alias{va_methods}
\alias{convertVA}
\alias{convertVA.quali}
\alias{convertVA.snellen}
\alias{convertVA.logmar}
\alias{convertVA.etdrs}
\alias{convertVA.default}
\title{VA conversion methods}
\usage{
convertVA(x, to, ...)

\method{convertVA}{quali}(x, to, snellnot, ...)

\method{convertVA}{snellen}(x, to, snellnot, logmarstep, ...)

\method{convertVA}{logmar}(x, to, snellnot, ...)

\method{convertVA}{etdrs}(x, to, snellnot, ...)

\method{convertVA}{default}(x, to, snellnot, ...)
}
\arguments{
\item{x}{vector of visual acuities}

\item{to}{to which VA class to convert}

\item{...}{further arguments passed to methods}

\item{snellnot}{which snellen notation. One of "ft", "m" or "dec"}

\item{logmarstep}{how plus/minus entries are evaluated. Default to
increase/decrease snellen fractions by lines. If TRUE, each snellen
optotype will be considered equivalent to 0.02 logmar or 1 ETDRS
letter (assuming 5 letters in a row in a chart)}
}
\value{
vector with visual acuity of class \code{va}. See also "VA classes"
}
\description{
S3 methods for VA conversion
}
\details{
VA can be snellen feet/meter/decimal, logMAR, ETDRS, or
"qualitative" (Counting fingers, etc.)
\itemize{
\item Snellen fractions need to be either form 6/x or 20/x
\item ETDRS must be between 0 and 100
\item logMAR must be between -0.3 and 3.0
\item Qualitative must be PL, LP, NLP, NPL, HM, CF (any case allowed)
}

Any element which is not recognized will be converted to NA

For other conversion rules see \link{va}
}
\section{Conversion}{

Although there seems to be no good statistical reason to convert
back to Snellen, it is a very natural thing to eye specialists to think
in Snellen. A conversion to snellen gives a good gauge of how the visual
acuity for the patients are. However, back-conversion should not be
considered an exact science and any attempt to use formulas will result
in very weird Snellen values that have no correspondence to common charts.
Therefore, Snellen matching the nearest ETDRS and logMAR value in
the \link{va_chart} are used.

Further:
\itemize{
\item logMAR to ETDRS: logMAR rounded to the first digit and converted with
the chart.
\item Snellen to logMAR: logMAR = -1 * log10(snellen_frac)
\item Snellen to ETDRS: ETDRS = 85 + 50 * log10(snellen_frac)
\href{https://doi.org/10.1097/iae.0b013e3181d87e04}{Gregori et al.}.
\item ETDRS to logMAR: logMAR = -0.02 * etdrs + 1.7
\href{https://doi.org/10.1016/s0002-9394(02)01825-1}{Beck et al.}
}
}

\section{VA classes}{

convert_VA returns a vector of three classes:
\enumerate{
\item \code{va}
\item One of \code{snellen}, \code{logmar}, \code{etdrs} or \code{quali}.
\item Either of \code{character} (for Snellen and qualitative),
\code{numeric} (for logMAR), or \code{integer} (for ETDRS).
}
}

\seealso{
Other VA converter: 
\code{\link{snellen_steps}},
\code{\link{va_dissect}()},
\code{\link{va}()},
\code{\link{which_va}()}
}
\concept{VA converter}
