% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AOI_seq.R
\name{AOI_seq}
\alias{AOI_seq}
\title{Sequence analysis of area of interest entries}
\usage{
AOI_seq(data, AOIs, AOI_names = NULL, participant_ID = "participant_ID")
}
\arguments{
\item{data}{A dataframe with fixation data (from fixation_dispersion). Either single or multi participant data}

\item{AOIs}{A dataframe of areas of interest (AOIs), with one row per AOI (x, y, width_radius, height).}

\item{AOI_names}{An optional vector of AOI names to replace the default "AOI_1", "AOI_2", etc.}

\item{participant_ID}{the variable that determines the participant identifier. If no column present, assumes a single participant}
}
\value{
a dataframe containing the sequence of entries into AOIs on each trial, entry/exit/duration time into AOI
}
\description{
Analyses the sequence of entries into defined AOI regions across trials. Can only be used with fixation data with a "fix_n" column denoting fixation events.
}
\examples{
\donttest{
data <- combine_eyes(HCL)
fix_d <- fixation_dispersion(data, participant_ID = "pNum")

AOI_seq(fix_d, AOIs = HCL_AOIs, participant_ID = "pNum")
}

}
