% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditional_transform.R
\name{conditional_transform}
\alias{conditional_transform}
\title{conditional_transform}
\usage{
conditional_transform(
  data,
  flip = c("x", "y"),
  cond_column,
  cond_values,
  resolution_x = 1920,
  resolution_y = 1080,
  message = TRUE
)
}
\arguments{
\item{data}{a dataframe that includes columns x and y and the column specified in cond_column. Can be raw, fixation, or saccade data.}

\item{flip}{either "x", to flip across vertical midline, or "y" to flip across horizontal midline}

\item{cond_column}{a column name, on which the flips are conditional}

\item{cond_values}{a single value or vector stating which values in con_column result in a flip}

\item{resolution_x}{screen size in pixels for the x axis}

\item{resolution_y}{screen size in pixels for the y axis}

\item{message}{whether to output messages during function. Useful to turn off when using in a vectorised fashion where it is running multiple times}
}
\value{
a dataframe of the equivalent format as the input data
}
\description{
A function to perform conditional transformations of the x/y raw data.
The function takes the dataframe and performs a single axis flip based on the values specified in the cond_column.
The primary use of this function is to correct or normalise the data when counterbalancing stimulus placement within experiments (e.g., having a target stimulus appear on the left and right equally often)
}
\examples{
data <- combine_eyes(HCL)
data <- merge(data, HCL_behavioural)
conditional_transform(data, flip = "x",
                      cond_column = "cue_order",
                      cond_values = 2)
}
