% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_hmm.R
\name{simulate_hmm}
\alias{simulate_hmm}
\title{Simulate data}
\usage{
simulate_hmm(
  controls = list(),
  hierarchy = FALSE,
  states = if (!hierarchy) 2 else c(2, 2),
  sdds = if (!hierarchy) "normal" else c("normal", "normal"),
  horizon = if (!hierarchy) 100 else c(100, 30),
  period = if (hierarchy && is.na(horizon[2])) "m" else NA,
  true_parameters = fHMM_parameters(controls = controls, hierarchy = hierarchy, states =
    states, sdds = sdds),
  seed = NULL
)
}
\arguments{
\item{controls}{Either a \code{list} or an object of class \code{fHMM_controls}.

The \code{list} can contain the following elements, which are described
in more detail below:
\itemize{
\item \code{hierarchy}, defines an hierarchical HMM,
\item \code{states}, defines the number of states,
\item \code{sdds}, defines the state-dependent distributions,
\item \code{horizon}, defines the time horizon,
\item \code{period}, defines a flexible, periodic fine-scale time horizon,
\item \code{data}, a \code{list} of controls that define the data,
\item \code{fit}, a \code{list} of controls that define the model fitting
}
Either none, all, or selected elements can be specified.

Unspecified parameters are set to their default values, see below.

Specifications in \code{controls} override individual specifications.}

\item{hierarchy}{A \code{logical}, set to \code{TRUE} for an hierarchical HMM.

If \code{hierarchy = TRUE}, some of the other controls must be specified for
the coarse-scale and the fine-scale layer.

By default, \code{hierarchy = FALSE}.}

\item{states}{An \code{integer}, the number of states of the underlying Markov chain.

If \code{hierarchy = TRUE}, \code{states} must be a \code{vector} of length
2. The first entry corresponds to the coarse-scale layer, while the second
entry corresponds to the fine-scale layer.

By default, \code{states = 2} if \code{hierarchy = FALSE} and
\code{states = c(2, 2)} if \code{hierarchy = TRUE}.}

\item{sdds}{A \code{character}, specifying the state-dependent distribution. One of
\itemize{
\item \code{"normal"} (the normal distribution),
\item \code{"lognormal"} (the log-normal distribution),
\item \code{"t"} (the t-distribution),
\item \code{"gamma"} (the gamma distribution),
\item \code{"poisson"} (the Poisson distribution).
}

The distribution parameters, i.e. the
\itemize{
\item mean \code{mu},
\item standard deviation \code{sigma} (not for the Poisson distribution),
\item degrees of freedom \code{df} (only for the t-distribution),
}
can be fixed via, e.g., \code{"t(df = 1)"} or
\code{"gamma(mu = 0, sigma = 1)"}.
To fix different values of a parameter for different states, separate by
"|", e.g. \code{"poisson(mu = 1|2|3)"}.

If \code{hierarchy = TRUE}, \code{sdds} must be a \code{vector} of length 2.
The first entry corresponds to the coarse-scale layer, while the second entry
corresponds to the fine-scale layer.

By default, \code{sdds = "normal"} if \code{hierarchy = FALSE} and
\code{sdds = c("normal", "normal")} if \code{hierarchy = TRUE}.}

\item{horizon}{A \code{numeric}, specifying the length of the time horizon.

If \code{hierarchy = TRUE}, \code{horizon} must be a \code{vector} of length
2. The first entry corresponds to the coarse-scale layer, while the second
entry corresponds to the fine-scale layer.

By default, \code{horizon = 100} if \code{hierarchy = FALSE} and
\code{horizon = c(100, 30)} if \code{hierarchy = TRUE}.

If \code{data} is specified (i.e., not \code{NA}), the first entry of
\code{horizon} is ignored and the (coarse-scale) time horizon is defined by
available data.}

\item{period}{Only relevant if \code{hierarchy = TRUE} and \code{horizon[2] = NA}.

In this case, a \code{character} which specifies a flexible, periodic
fine-scale time horizon and can be one of
\itemize{
\item \code{"w"} for a week,
\item \code{"m"} for a month,
\item \code{"q"} for a quarter,
\item \code{"y"} for a year.
}

By default, \code{period = "m"} if \code{hierarchy = TRUE} and
\code{horizon[2] = NA}, and \code{NA} else.}

\item{true_parameters}{An object of class \code{fHMM_parameters}, used as simulation parameters.
By default, \code{true_parameters = NULL}, i.e., sampled true parameters.}

\item{seed}{Set a seed for the data simulation.
No seed per default.}
}
\value{
A \code{list} containing the following elements:
\itemize{
\item \code{time_points}, the \code{vector} (or \code{matrix} in the
hierarchical case) of time points,
\item \code{markov_chain}, the \code{vector} (or \code{matrix} in the
hierarchical case) of the simulated states,
\item \code{data}, the \code{vector} (or \code{matrix} in the hierarchical
case) of the simulated state-dependent observations,
\item \code{T_star}, the \code{numeric} vector of fine-scale chunk sizes
in the hierarchical case
}
}
\description{
This helper function simulates HMM data.
}
