% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fHMM_data.R
\name{fHMM_data}
\alias{fHMM_data}
\alias{print.fHMM_data}
\alias{summary.fHMM_data}
\title{Constructor of an \code{fHMM_data} object}
\usage{
fHMM_data(
  dates,
  time_points,
  markov_chain,
  data,
  time_series,
  T_star,
  controls,
  true_parameters
)

\method{print}{fHMM_data}(x, ...)

\method{summary}{fHMM_data}(object, ...)
}
\arguments{
\item{dates}{The dates in the empirical case.}

\item{time_points}{The time points in the simulated case.}

\item{markov_chain}{The states in the simulated case.}

\item{data}{The data for modeling.}

\item{time_series}{The data before transformation.}

\item{T_star}{The fine-scale chunk sizes.}

\item{controls}{The \code{fHMM_controls} object.}

\item{true_parameters}{The \code{fHMM_parameters} object in the simulated case.}

\item{x}{An object of class \code{fHMM_data}.}

\item{...}{Currently not used.}

\item{object}{An object of class \code{fHMM_data}.}
}
\value{
An object of class \code{fHMM_data}, which is a \code{list} containing
the following elements:
\itemize{
\item The \code{matrix} of the \code{dates} if \code{simulated = FALSE} and
\code{controls$data$data_column} is specified,
\item the \code{matrix} of the \code{time_points} if \code{simulated = TRUE}
or \code{controls$data$data_column} is not specified,
\item the \code{matrix} of the simulated \code{markov_chain} if
\code{simulated = TRUE},
\item the \code{matrix} of the simulated or empirical \code{data} used for
estimation,
\item the \code{matrix} \code{time_series} of empirical data before the
transformation to log-returns if \code{simulated = FALSE},
\item the \code{vector} of fine-scale chunk sizes \code{T_star} if
\code{controls$hierarchy = TRUE},
\item the input \code{controls},
\item the \code{true_parameters}.
}
}
\description{
This function constructs an object of class \code{fHMM_data}, which contains
the financial data for modeling.
}
