% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dual_reg.R
\name{dual_reg}
\alias{dual_reg}
\title{Dual Regression}
\usage{
dual_reg(
  BOLD,
  GICA,
  scale = c("local", "global", "none"),
  scale_sm_xifti = NULL,
  scale_sm_FWHM = 2,
  TR = NULL,
  hpf = 0.01,
  lpf = NULL,
  GSR = FALSE
)
}
\arguments{
\item{BOLD}{Subject-level fMRI data matrix (\eqn{V \times T}). Rows will be
centered.}

\item{GICA}{Group-level independent components (\eqn{V \times Q})}

\item{scale}{\code{"local"} (default), \code{"global"}, or \code{"none"}.
Local scaling will divide each data location's time series by its estimated
standard deviation. Global scaling will divide the entire data matrix by the
mean image standard deviation (\code{mean(sqrt(rowVars(BOLD)))}).}

\item{scale_sm_xifti, scale_sm_FWHM}{Only applies if \code{scale=="local"} and
\code{BOLD} represents CIFTI-format data. To smooth the standard deviation
estimates used for local scaling, provide a \code{"xifti"} object with data
locations in alignment with \code{BOLD}, as well as the smoothing FWHM
(default: \code{2}). If no \code{"xifti"} object is provided (default), do
not smooth.}

\item{TR}{The temporal resolution of the data, i.e. the time between volumes,
in seconds. \code{TR} is required for detrending with \code{hpf}.}

\item{hpf, lpf}{The frequencies at which to apply a highpass filter or lowpass
filter to the data during pre-processing, in Hertz. Set either to
\code{NULL} to disable filtering. Default: \code{0.01} Hertz for the
highpass filter, and \code{NULL} for the lowpass filter.

The highpass filter serves to detrend the data, since low-frequency
variance is associated with noise. Highpass filtering is accomplished by
nuisance regression of discrete cosine transform (DCT) bases.

The lowpass filter removes high-frequency variance also thought to be
associated with non-neuronal noise.

Note the \code{TR} argument is required for temporal filtering. If
\code{TR} is not provided, \code{hpf} and \code{lpf} will be ignored.}

\item{GSR}{Center BOLD across columns (each image)? This
is equivalent to performing global signal regression. Default:
\code{FALSE}.}
}
\value{
A list containing
the subject-level independent components \strong{S} (\eqn{V \times Q}),
and subject-level mixing matrix \strong{A} (\eqn{TxQ}).
}
\description{
Dual Regression
}
\examples{
nT <- 30
nV <- 400
nQ <- 7
mU <- matrix(rnorm(nV*nQ), nrow=nV)
mS <- mU \%*\% diag(seq(nQ, 1)) \%*\% matrix(rnorm(nQ*nT), nrow=nQ)
BOLD <- mS + rnorm(nV*nT, sd=.05)
GICA <- mU
dual_reg(BOLD=BOLD, GICA=mU, scale="local")

}
