% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_FC.R
\name{plot_FC}
\alias{plot_FC}
\title{Plot FC}
\usage{
plot_FC(
  FC,
  zlim = c(-1, 1),
  diag_val = NULL,
  title = "FC matrix",
  cols = color_palette("Beach"),
  cleg_ticks_by = diff(zlim)/2,
  cleg_digits = NULL,
  labels = NULL,
  lines = NULL,
  lines_col = "black",
  lines_lwd = 1,
  cex = 0.8
)
}
\arguments{
\item{FC}{The functional connectivity matrix, a square numeric matrix with
values between -1 and 1.}

\item{zlim}{The minimum and maximum range of the color scale. Default:
\code{c(-1, 1)}. If in descending order, the color scale will be reversed.}

\item{diag_val}{Set to \code{NA} for white, \code{1}, or \code{NULL}
(default) to not modify the diagonal values in \code{FC}.}

\item{title}{(Optional) Plot title.}

\item{cols}{Character vector of colors for the color scale. Default:
\code{color_palette("Beach")}.}

\item{cleg_ticks_by}{Spacing between ticks on the color legend. Default:
\code{range(zlim)/2}.}

\item{cleg_digits}{How many decimal digits for the color legend. Default:
\code{NULL} to set automatically.}

\item{labels}{A character vector of length \code{length(lines)+1}, giving
row/column labels for the submatrices divided by \code{lines}. If
\code{NULL} (default), do not add labels.}

\item{lines}{Add lines to divide the FC matrix into submatrices? Default:
\code{NULL} (do not draw lines). Set to \code{"all"} to delineate each
individual row and column.}

\item{lines_col, lines_lwd}{Color and line width of the \code{lines}. Default:
black lines of width \code{1}.}

\item{cex}{Text size. Default: \code{0.8}.}
}
\description{
Plot a functional connectivity matrix.
}
