% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-viz.R
\name{summary_text}
\alias{summary_text}
\title{Create summary table of one (possibly grouped) text-type column in a tibble}
\usage{
summary_text(
  tbl = "dplyr::storms",
  col = "status",
  filter = "c()",
  negate = FALSE,
  missing_values = "c()",
  out = "DT-cat",
  group_by = NULL
)
}
\arguments{
\item{tbl}{A character string or tibble specifying the input tibble}

\item{col}{A character string specifying a column of interest}

\item{filter}{A character string specifying the values to filter. (equivalent
to 'values in'). This determines which values should be retained. It can be
applied to both grouped and ungrouped data.}

\item{negate}{If TRUE, return non-matching elements.}

\item{missing_values}{Vector listing values to exclude from valid values.
These values will not be excluded from counting - but will be displayed
separately from valid values.}

\item{out}{parameter that specifies the output expected: can be either 'DT',
'DT-code' and 'DT-cat'. DT renders a datatable using DT library, code gives
the code in a string (usable directly with eval/parse functions) and cat
provides indented code in the console.}

\item{group_by}{A character string of one column in the tbl that can be
taken as a grouping column. The visual element will be grouped and displayed
by this column.}
}
\value{
A datatable (editable) object or a R script in a character string to create
it.
}
\description{
This function creates a datatable of the values of a column with separate
valid, non-valid and missing values.
Missing values can be given as input to non-valid and valid values
separately, or grouped by another column. The output can be editable (using
plotly library) or static (using ggplot2 library). The R-code is also
editable for coding recycling purpose. The user can download the datatable in
csv format.
}
\examples{
{

##### Example 1 -------------------------------------------------------------
# cat output generated as a template when no argument provided
summary_text()

##### Example 2 -------------------------------------------------------------
# summary table of Species
summary_text(tbl = "dplyr::storms", col = "status", out = "DT")

}

}
\seealso{
\code{\link[DT:datatable]{DT::datatable()}}
}
