% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{autoplot.fbl_ts}
\alias{autoplot.fbl_ts}
\alias{autolayer.fbl_ts}
\title{Plot a set of forecasts}
\usage{
\method{autoplot}{fbl_ts}(object, data = NULL, level = c(80, 95), ...)

\method{autolayer}{fbl_ts}(object, level = c(80, 95), ...)
}
\arguments{
\item{object}{A fable.}

\item{data}{A tsibble with the same key structure as the fable.}

\item{level}{The confidence levels for the plotted prediction intervals.}

\item{...}{Further arguments passed used to specify fixed aesthetics for the forecasts such as \code{colour = "red"} or \code{size = 3}.}
}
\description{
Produces a forecast plot from a fable. As the original data is not included
in the fable object, it will need to be specified via the \code{data} argument.
The \code{data} argument can be used to specify a shorter period of data, which is
useful to focus on the more recent observations.
}
\examples{
library(tsibbledata)
if (requireNamespace("fable", quietly = TRUE)) {
library(fable)

fc <- aus_production \%>\%
  model(ets = ETS(log(Beer) ~ error("M") + trend("Ad") + season("A"))) \%>\% 
  forecast(h = "3 years") 

fc \%>\% 
  autoplot(aus_production)
}


if (requireNamespace("fable", quietly = TRUE)) {
aus_production \%>\% 
  autoplot(Beer) + 
  autolayer(fc)
}

}
