% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MGFmixedgamma.R
\name{MGFmixedgamma}
\alias{MGFmixedgamma}
\title{Evaluate the moment generating function (MGF) of the mixed gamma distribution or a derivative of the MGF}
\usage{
MGFmixedgamma(x, prob, rate, shape, deriv = 0)
}
\arguments{
\item{x}{The value at which to evaluate the MGF}

\item{prob}{A vector of probabilities of following each gamma distribution in the mixture}

\item{rate}{A vector of rate parameter values for each gamma distribution in the mixture}

\item{shape}{A vector of shape parameter values for each gamma distribution in the mixture}

\item{deriv}{An integer, the number of derivatives of the MGF to apply}
}
\value{
The number resulting from the function evaluation
}
\description{
Evaluate the moment generating function (MGF) of the mixed gamma distribution or a derivative of the MGF
}
\examples{
# MGF of a 40/60 mixture of two gamma distributions, evaluated at -0.1:
MGFmixedgamma(-0.1, prob = c(0.4,0.6), rate = c(0.4,0.7), shape = c(0.5,3))
# Second moment of the distribution (second derivative evaluated at zero):
MGFmixedgamma(0, prob = c(0.4,0.6), rate = c(0.4,0.7), shape = c(0.5,3), deriv = 2)
}
