% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pca.R
\name{get_pca}
\alias{get_pca}
\alias{get_pca_ind}
\alias{get_pca_var}
\title{Extract the results for individuals/variables - PCA}
\usage{
get_pca(res.pca, element = c("var", "ind"))

get_pca_ind(res.pca, ...)

get_pca_var(res.pca)
}
\arguments{
\item{res.pca}{an object of class PCA [FactoMineR]; 
prcomp and princomp [stats]; pca, dudi [adea4]; epPCA [ExPosition].}

\item{element}{the element to subset from the output. Allowed values are 
"var" (for active variables) or "ind" (for active individuals).}

\item{...}{not used}
}
\value{
a list of matrices containing all the results for the active individuals/variables including: 
\item{coord}{coordinates for the individuals/variables}
\item{cos2}{cos2 for the individuals/variables}
\item{contrib}{contributions of the individuals/variables}
}
\description{
Extract all the results (coordinates, squared cosine, contributions) for 
the active individuals/variables from Principal Component Analysis (PCA) outputs.\cr\cr
\itemize{
\item get_pca(): Extract the results for variables and individuals
\item get_pca_ind(): Extract the results for individuals only
\item get_pca_var(): Extract the results for variables only
}
}
\examples{
\donttest{
# Principal Component Analysis
# +++++++++++++++++++++++++++++
 data(iris)
 res.pca <- prcomp(iris[, -5],  scale = TRUE)
 # Extract the results for individuals
 ind <- get_pca_ind(res.pca)
 print(ind)
 head(ind$coord) # coordinates of individuals
 head(ind$cos2) # cos2 of individuals
 head(ind$contrib) # contributions of individuals
 
 # Extract the results for variables
 var <- get_pca_var(res.pca)
 print(var)
 head(var$coord) # coordinates of variables
 head(var$cos2) # cos2 of variables
 head(var$contrib) # contributions of variables
 
 # You can also use the function get_pca()
 get_pca(res.pca, "ind") # Results for individuals
 get_pca(res.pca, "var") # Results for variable categories
 }
}
\author{
Alboukadel Kassambara \email{alboukadel.kassambara@gmail.com}
}
\references{
http://www.sthda.com/english/
}

