% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_fsvsim.R
\name{cormat.fsvsim}
\alias{cormat.fsvsim}
\title{Extract "true" model-implied correlation matrix for several points in time}
\usage{
\method{cormat}{fsvsim}(x, timepoints = "all", ...)
}
\arguments{
\item{x}{Object of class \code{'fsvsim'}, usually resulting from a call
of the function \code{\link{fsvsim}}.}

\item{timepoints}{Vector indicating at which point(s) in time the
correlation matrices should be extracted. Can also be "all" or "last".}

\item{...}{Ignored.}
}
\value{
Array of dimension \code{m} times \code{m} times
\code{length(timepoints)}, containing the model-implied correlation matrix.
}
\description{
\code{cormat} extracts the model-implied (time-varying) covariance matrix
from an \code{fsvsim} object.
}
\note{
Currently crudely implemented as an R loop over all time points,
may be slow.
}
\seealso{
Other simulation: \code{\link{corelement}},
  \code{\link{covelement}}, \code{\link{covmat.fsvsim}}
}
\concept{simulation}
