% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_fsvdraws.R
\name{runningcormat}
\alias{runningcormat}
\title{Extract summary statistics for the posterior correlation matrix
which have been stored during sampling}
\usage{
runningcormat(x, i, statistic = "mean", type = "cor")
}
\arguments{
\item{x}{Object of class \code{'fsvdraws'}, usually resulting from a call
of \code{\link{fsvsample}}.}

\item{i}{A single point in time.}

\item{statistic}{Indicates which statistic should be extracted. Defaults
to \code{'mean'}.}

\item{type}{Indicates whether covariance (\code{cov}) or correlation
(\code{cor}) should be extracted.}
}
\value{
Matrix containing the requested correlation matrix summary statistic.
}
\description{
\code{runningcormat} extracts summary statistics from the model-implied
correlation matrix
from an \code{fsvdraws} object for one point in time.
}
\examples{
\dontrun{
set.seed(1)
sim <- fsvsim(n = 500, series = 3, factors = 1) # simulate 
res <- fsvsample(sim$y, factors = 1, runningstore = 6) # estimate

cor100mean <- runningcormat(res, 100) # extract mean at t = 100
cor100sd <- runningcormat(res, 100, statistic = "sd") # extract sd
lower <- cor100mean - 2*cor100sd
upper <- cor100mean + 2*cor100sd

true <- cov2cor(covmat(sim, 100)[,,1]) # true value

# Visualize mean +/- 2sd and data generating values
par(mfrow = c(3,3), mar = c(2, 2, 2, 2))
for (i in 1:3) {
 for (j in 1:3) {
  plot(cor100mean[i,j], ylim = range(lower, upper), pch = 3,
  main = paste(i, j, sep = ' vs. '), xlab = '', ylab = '')
  lines(c(1,1), c(lower[i,j], upper[i,j]))
  points(true[i,j], col = 3, cex = 2)
 }
}
}

}
\seealso{
Other extractors: \code{\link{covmat.fsvdraws}},
  \code{\link{runningcovmat}}
}
\concept{extractors}
