# Engines API
#
# Allow clients to fetch Engines Analytics through APIs.
#
# The version of the OpenAPI document: 2
# Contact: analytics.api.support@factset.com
# Generated by: https://openapi-generator.tech

#' @docType class
#' @title PADateParameters
#' @description PADateParameters Class
#' @format An \code{R6Class} generator object
#' @field startdate  character [optional]
#'
#' @field enddate  character 
#'
#' @field frequency  character 
#'
#'
#' @importFrom R6 R6Class
#' @importFrom jsonlite fromJSON toJSON
#' @export
PADateParameters <- R6::R6Class(
  'PADateParameters',
  public = list(
    `startdate` = NULL,
    `enddate` = NULL,
    `frequency` = NULL,
    initialize = function(`enddate`, `frequency`, `startdate`=NULL, ...){
      local.optional.var <- list(...)
      if (!missing(`enddate`)) {
        stopifnot(is.character(`enddate`), length(`enddate`) == 1)
        self$`enddate` <- `enddate`
      }
      if (!missing(`frequency`)) {
        stopifnot(is.character(`frequency`), length(`frequency`) == 1)
        self$`frequency` <- `frequency`
      }
      if (!is.null(`startdate`)) {
        stopifnot(is.character(`startdate`), length(`startdate`) == 1)
        self$`startdate` <- `startdate`
      }
    },
    toJSON = function() {
      PADateParametersObject <- list()
      if (!is.null(self$`startdate`)) {
        PADateParametersObject[['startdate']] <-
          self$`startdate`
      }
      if (!is.null(self$`enddate`)) {
        PADateParametersObject[['enddate']] <-
          self$`enddate`
      }
      if (!is.null(self$`frequency`)) {
        PADateParametersObject[['frequency']] <-
          self$`frequency`
      }

      PADateParametersObject
    },
    fromJSON = function(PADateParametersJson) {
      PADateParametersObject <- jsonlite::fromJSON(PADateParametersJson)
      if (!is.null(PADateParametersObject$`startdate`)) {
        self$`startdate` <- PADateParametersObject$`startdate`
      }
      if (!is.null(PADateParametersObject$`enddate`)) {
        self$`enddate` <- PADateParametersObject$`enddate`
      }
      if (!is.null(PADateParametersObject$`frequency`)) {
        self$`frequency` <- PADateParametersObject$`frequency`
      }
    },
    toJSONString = function() {
      jsoncontent <- c(
        if (!is.null(self$`startdate`)) {
        sprintf(
        '"startdate":
          "%s"
                ',
        self$`startdate`
        )},
        if (!is.null(self$`enddate`)) {
        sprintf(
        '"enddate":
          "%s"
                ',
        self$`enddate`
        )},
        if (!is.null(self$`frequency`)) {
        sprintf(
        '"frequency":
          "%s"
                ',
        self$`frequency`
        )}
      )
      jsoncontent <- paste(jsoncontent, collapse = ",")
      paste('{', jsoncontent, '}', sep = "")
    },
    fromJSONString = function(PADateParametersJson) {
      PADateParametersObject <- jsonlite::fromJSON(PADateParametersJson)
      self$`startdate` <- PADateParametersObject$`startdate`
      self$`enddate` <- PADateParametersObject$`enddate`
      self$`frequency` <- PADateParametersObject$`frequency`
      self
    }
  )
)
