
# extract the coefficients.
coef.fair.model = function(object, ...) {

  if (!inherits(object, "fair.model"))
    stop("'object' must be a 'fair.model' object.")

  check.unused.args(list(...), character(0))

  return(object$main$coefficients)

}#COEF.FAIR.MODEL

# extract the residuals.
residuals.fair.model = function(object, ...) {

  if (!inherits(object, "fair.model"))
    stop("'object' must be a 'fair.model' object.")

  check.unused.args(list(...), character(0))

  return(object$main$residuals)

}#RESIDUALS.FAIR.MODEL

# extract the fitted values.
fitted.fair.model = function(object, type = "response", ...) {

  if (!inherits(object, "fair.model"))
    stop("'object' must be a 'fair.model' object.")

  # check the type of fitted values.
  if (inherits(object, fair.regressions) ||
      (inherits(object, fair.family) && (object$main$family == "gaussian")))
    check.label(type, c("response"), "fitted value type")
  else if (inherits(object, fair.classifiers) ||
            (inherits(object, fair.family) && (object$main$family == "binomial")))
    check.label(type, c("response", "class", "link"), "fitted value type")

  check.unused.args(list(...), character(0))

  if (type == "link") {

    return(prob2link(object$main$fitted))

  }#THEN
  if (type == "response") {

    return(object$main$fitted)

  }#THEN
  else if (type == "class") {

    return(prob2class(object$main$fitted,
             labels = object$data$response$levels[["response"]]))

  }#THEN

}#FITTED.FAIR.MODEL

# extract the training sample size.
nobs.fair.model = function(object, ...) {

  if (!inherits(object, "fair.model"))
    stop("'object' must be a 'fair.model' object.")

  check.unused.args(list(...), character(0))

  return(length(object$main$fitted))

}#NOBS.FAIR.MODEL

# extract the estimated standard deviation of the errors.
sigma.fair.model = function(object, ...) {

  if (!inherits(object, "fair.model"))
    stop("'object' must be a 'fair.model' object.")

  check.unused.args(list(...), character(0))

  resid.df = nobs(object, ...) - sum(!is.na(coef(object)))

  return(sqrt(deviance(object, ...) / resid.df))

}#SIGMA.FAIR.MODEL

# deviance for fair models.
deviance.fair.model = function(object, ...) {

  if (!inherits(object, "fair.model"))
    stop("'object' must be an 'fair.model' object.")

  check.unused.args(list(...), character(0))

  return(object$main$deviance)

}#DEVIANCE.FAIR.MODEL

logLik.fair.model = function(object, ...) {

  if (!inherits(object, "fair.model"))
    stop("'object' must be an 'fair.model' object.")

  check.unused.args(list(...), character(0))

  return(object$main$loglik)

}#LOGLIK.FAIR.MODEL
