% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.fairness_heatmap}
\alias{print.fairness_heatmap}
\title{Print fairness heatmap}
\usage{
\method{print}{fairness_heatmap}(x, ...)
}
\arguments{
\item{x}{\code{fairness_heatmap} object}

\item{...}{other print parameters}
}
\description{
Print fairness heatmap
}
\examples{

data("german")

y_numeric <- as.numeric(german$Risk) -1

lm_model <- glm(Risk~.,
                data = german,
                family=binomial(link="logit"))

rf_model <- ranger::ranger(Risk ~.,
                           data = german,
                           probability = TRUE,
                           num.trees = 200)

explainer_lm <- DALEX::explain(lm_model, data = german[,-1], y = y_numeric)
explainer_rf <- DALEX::explain(rf_model, data = german[,-1], y = y_numeric)

fobject <- fairness_check(explainer_lm, explainer_rf,
                          protected = german$Sex,
                          privileged = "male")

 # same explainers with different cutoffs for female
 fobject <- fairness_check(explainer_lm, explainer_rf, fobject,
                          protected = german$Sex,
                          privileged = "male",
                          cutoff = list( female = 0.4),
                          label = c("lm_2", "rf_2"))


fh <- fairness_heatmap(fobject)
print(fh)

}
