% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FamiliarDataComputationFeatureExpression.R
\name{export_feature_expressions}
\alias{export_feature_expressions}
\alias{export_feature_expressions,familiarCollection-method}
\alias{export_feature_expressions,ANY-method}
\title{Extract and export feature expressions.}
\usage{
export_feature_expressions(
  object,
  dir_path = NULL,
  evaluation_time = waiver(),
  export_collection = FALSE,
  ...
)

\S4method{export_feature_expressions}{familiarCollection}(
  object,
  dir_path = NULL,
  evaluation_time = waiver(),
  export_collection = FALSE,
  ...
)

\S4method{export_feature_expressions}{ANY}(
  object,
  dir_path = NULL,
  evaluation_time = waiver(),
  export_collection = FALSE,
  ...
)
}
\arguments{
\item{object}{A \code{familiarCollection} object, or other other objects from which
a \code{familiarCollection} can be extracted. See details for more information.}

\item{dir_path}{Path to folder where extracted data should be saved. \code{NULL}
will allow export as a structured list of data.tables.}

\item{evaluation_time}{One or more time points that are used to create the
outcome columns in expression plots. If not provided explicitly, this
parameter is read from settings used at creation of the underlying
\code{familiarData} objects. Only used for \code{survival} outcomes.}

\item{export_collection}{(\emph{optional}) Exports the collection if TRUE.}

\item{...}{
  Arguments passed on to \code{\link[=extract_feature_expression]{extract_feature_expression}}, \code{\link[=as_familiar_collection]{as_familiar_collection}}
  \describe{
    \item{\code{feature_similarity}}{Table containing pairwise distance between
sample. This is used to determine cluster information, and indicate which
samples are similar. The table is created by the
\code{extract_sample_similarity} method.}
    \item{\code{data}}{A \code{dataObject} object, \code{data.table} or \code{data.frame} that
constitutes the data that are assessed.}
    \item{\code{feature_cluster_method}}{The method used to perform clustering. These are
the same methods as for the \code{cluster_method} configuration parameter:
\code{none}, \code{hclust}, \code{agnes}, \code{diana} and \code{pam}.

\code{none} cannot be used when extracting data regarding mutual correlation or
feature expressions.

If not provided explicitly, this parameter is read from settings used at
creation of the underlying \code{familiarModel} objects.}
    \item{\code{feature_linkage_method}}{The method used for agglomerative clustering in
\code{hclust} and \code{agnes}. These are the same methods as for the
\code{cluster_linkage_method} configuration parameter: \code{average}, \code{single},
\code{complete}, \code{weighted}, and \code{ward}.

If not provided explicitly, this parameter is read from settings used at
creation of the underlying \code{familiarModel} objects.}
    \item{\code{feature_similarity_metric}}{Metric to determine pairwise similarity
between features. Similarity is computed in the same manner as for
clustering, and \code{feature_similarity_metric} therefore has the same options
as \code{cluster_similarity_metric}: \code{mcfadden_r2}, \code{cox_snell_r2},
\code{nagelkerke_r2}, \code{spearman}, \code{kendall} and \code{pearson}.

If not provided explicitly, this parameter is read from settings used at
creation of the underlying \code{familiarModel} objects.}
    \item{\code{sample_cluster_method}}{The method used to perform clustering based on
distance between samples. These are the same methods as for the
\code{cluster_method} configuration parameter: \code{hclust}, \code{agnes}, \code{diana} and
\code{pam}.

\code{none} cannot be used when extracting data for feature expressions.

If not provided explicitly, this parameter is read from settings used at
creation of the underlying \code{familiarModel} objects.}
    \item{\code{sample_linkage_method}}{The method used for agglomerative clustering in
\code{hclust} and \code{agnes}. These are the same methods as for the
\code{cluster_linkage_method} configuration parameter: \code{average}, \code{single},
\code{complete}, \code{weighted}, and \code{ward}.

If not provided explicitly, this parameter is read from settings used at
creation of the underlying \code{familiarModel} objects.}
    \item{\code{sample_similarity_metric}}{Metric to determine pairwise similarity
between samples. Similarity is computed in the same manner as for
clustering, but \code{sample_similarity_metric} has different options that are
better suited to computing distance between samples instead of between
features: \code{gower}, \code{euclidean}.

The underlying feature data is scaled to the \eqn{[0, 1]} range (for
numerical features) using the feature values across the samples. The
normalisation parameters required can optionally be computed from feature
data with the outer 5\% (on both sides) of feature values trimmed or
winsorised. To do so append \verb{_trim} (trimming) or \verb{_winsor} (winsorising) to
the metric name. This reduces the effect of outliers somewhat.

If not provided explicitly, this parameter is read from settings used at
creation of the underlying \code{familiarModel} objects.}
    \item{\code{evaluation_times}}{One or more time points that are used for in analysis of
survival problems when data has to be assessed at a set time, e.g.
calibration. If not provided explicitly, this parameter is read from
settings used at creation of the underlying \code{familiarModel} objects. Only
used for \code{survival} outcomes.}
    \item{\code{message_indent}}{Number of indentation steps for messages shown during
computation and extraction of various data elements.}
    \item{\code{verbose}}{Flag to indicate whether feedback should be provided on the
computation and extraction of various data elements.}
    \item{\code{familiar_data_names}}{Names of the dataset(s). Only used if the \code{object} parameter
is one or more \code{familiarData} objects.}
    \item{\code{collection_name}}{Name of the collection.}
  }}
}
\value{
A data.table (if \code{dir_path} is not provided), or nothing, as all data
is exported to \code{csv} files.
}
\description{
Extract and export feature expressions for the features in a
familiarCollection.
}
\details{
Data is usually collected from a \code{familiarCollection} object.
However, you can also provide one or more \code{familiarData} objects, that will
be internally converted to a \code{familiarCollection} object. It is also
possible to provide a \code{familiarEnsemble} or one or more \code{familiarModel}
objects together with the data from which data is computed prior to export.
Paths to the previous files can also be provided.

All parameters aside from \code{object} and \code{dir_path} are only used if \code{object}
is not a \code{familiarCollection} object, or a path to one.

Feature expressions are computed by standardising each feature, i.e. sample
mean is 0 and standard deviation is 1.
}
