% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FamiliarS4Classes.R
\docType{class}
\name{familiarCollection-class}
\alias{familiarCollection-class}
\title{Collection of familiar data.}
\description{
A familiarCollection object aggregates data from one or more familiarData
objects.
}
\section{Slots}{

\describe{
\item{\code{name}}{Name of the collection.}

\item{\code{data_sets}}{Name of the individual underlying datasets.}

\item{\code{outcome_type}}{Outcome type for which the collection was created.}

\item{\code{outcome_info}}{Outcome information object, which contains information
concerning the outcome, such as class levels.}

\item{\code{fs_vimp}}{Variable importance data collected by feature selection
methods.}

\item{\code{model_vimp}}{Variable importance data collected from model-specific
algorithms implemented by models created by familiar.}

\item{\code{permutation_vimp}}{Data collected for permutation variable importance.}

\item{\code{hyperparameters}}{Hyperparameters collected from created models.}

\item{\code{hyperparameter_data}}{Additional data concerning hyperparameters. This is
currently not used yet.}

\item{\code{required_features}}{The set of features required for complete
reproduction, i.e. with imputation.}

\item{\code{model_features}}{The set of features that are required for using the
model, but without imputation.}

\item{\code{learner}}{Learning algorithm(s) used for data in the collection.}

\item{\code{fs_method}}{Feature selection method(s) used for data in the collection.}

\item{\code{prediction_data}}{Model predictions for the data in the collection.}

\item{\code{confusion_matrix}}{Confusion matrix information for the data in the
collection.}

\item{\code{decision_curve_data}}{Decision curve analysis data for the data in the
collection.}

\item{\code{calibration_info}}{Calibration information, e.g. baseline survival in the
development cohort.}

\item{\code{calibration_data}}{Model calibration data collected from data in the
collection.}

\item{\code{model_performance}}{Collection of model performance data for data in the
collection.}

\item{\code{km_info}}{Information concerning risk-stratification cut-off values for
data in the collection.}

\item{\code{km_data}}{Kaplan-Meier survival data for data in the collection.}

\item{\code{auc_data}}{AUC-ROC and AUC-PR data for data in the collection.}

\item{\code{ice_data}}{Individual conditional expectation data for data in the
collection. Partial dependence data are computed on the fly from these
data.}

\item{\code{univariate_analysis}}{Univariate analysis results of data in the
collection.}

\item{\code{feature_expressions}}{Feature expression values for data in the
collection.}

\item{\code{feature_similarity}}{Feature similarity information for data in the
collection.}

\item{\code{sample_similarity}}{Sample similarity information for data in the
collection.}

\item{\code{data_set_labels}}{Labels for the different datasets in the collection.
See `get_data_set_names` and `set_data_set_names`.}

\item{\code{learner_labels}}{Labels for the different learning algorithms used to
create the collection. See `get_learner_names` and `set_learner_names`.}

\item{\code{fs_method_labels}}{Labels for the different feature selection methods
used to create the collection. See `get_fs_method_names` and
`set_fs_method_names`.}

\item{\code{feature_labels}}{Labels for the features in this collection. See
`get_feature_names` and `set_feature_names`.}

\item{\code{km_group_labels}}{Labels for the risk strata in this collection. See
`get_risk_group_names` and `set_risk_group_names`.}

\item{\code{class_labels}}{Labels of the response variable. See `get_class_names` and
`set_class_names`.}

\item{\code{project_id}}{Identifier of the project that generated this collection.}

\item{\code{familiar_version}}{Version of the familiar package.

familiarCollection objects collect data from one or more familiarData
objects. This objects are important, as all plotting and export functions use
it. The fact that one can supply familiarModel, familiarEnsemble and
familiarData objects as arguments for these methods, is because familiar
internally converts these into familiarCollection objects prior to executing
the method.}
}}

