% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FamiliarDataComputationVimp.R
\name{extract_model_vimp}
\alias{extract_model_vimp}
\title{Internal function to extract variable importance from models.}
\usage{
extract_model_vimp(
  object,
  data,
  aggregation_method = waiver(),
  rank_threshold = waiver(),
  message_indent = 0L,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{object}{A \code{familiarEnsemble} object, which is an ensemble of one or more
\code{familiarModel} objects.}

\item{data}{A \code{dataObject} object, \code{data.table} or \code{data.frame} that
constitutes the data that are assessed.}

\item{aggregation_method}{Method for aggregating variable importances for the
purpose of evaluation. Variable importances are determined during feature
selection steps and after training the model. Both types are evaluated, but
feature selection variable importance is only evaluated at run-time.

See the documentation for the \code{vimp_aggregation_method} argument in
\code{summon_familiar} for information concerning the different available
methods.

If not provided explicitly, this parameter is read from settings used at
creation of the underlying \code{familiarModel} objects.}

\item{rank_threshold}{The threshold used to  define the subset of highly
important features during evaluation.

See the documentation for the \code{vimp_aggregation_rank_threshold} argument in
\code{summon_familiar} for more information.

If not provided explicitly, this parameter is read from settings used at
creation of the underlying \code{familiarModel} objects.}

\item{message_indent}{Number of indentation steps for messages shown during
computation and extraction of various data elements.}

\item{verbose}{Flag to indicate whether feedback should be provided on the
computation and extraction of various data elements.}

\item{...}{Unused arguments.}
}
\value{
A list containing variable importance information.
}
\description{
Aggregate variable importance from models in a
\code{familiarEnsemble}.
}
\keyword{internal}
