% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{term_cap_test}
\alias{term_cap_test}
\title{Test Terminal Capabilities}
\usage{
term_cap_test()
}
\value{
character the test vector, invisibly
}
\description{
Outputs ANSI CSI SGR formatted text to screen so that you may visually
inspect what color capabilities your terminal supports.  The three tested
terminal capabilities are:
}
\details{
\itemize{
\item "bright" for bright colors with SGR codes in 90-97 and 100-107
\item "256" for colors defined by "38;5;x" and "48;5;x" where x is in 0-255
\item "truecolor" for colors defined by "38;2;x;y;z" and "48;x;y;x" where x, y,
and z are in 0-255
}

Each of the color capabilities your terminal supports should be displayed
with a blue background and a red foreground.  For reference the corresponding
CSI SGR sequences are displayed as well.

You should compare the screen output from this function to
\code{getOption('fansi.term.cap')} to ensure that they are self consistent.

By default \code{fansi} assumes terminals support bright and 256 color
modes, and also tests for truecolor support via the $COLORTERM system
variable.
}
\examples{
term_cap_test()
}
\seealso{
\link{fansi} for details on how \emph{Control Sequences} are
interpreted, particularly if you are getting unexpected results.
}
