/*
 * Decompiled with CFR 0.152.
 */
package jfm.model;

import jfm.model.Types;
import jfm.model.VariableHolder;

public class CropInput
extends VariableHolder {
    private final double[] amounts;
    public final Types.VariableType associatedVariable;
    private double unitCost;

    public CropInput(double[] amnts, double uCost, Types.VariableType var) {
        this.amounts = amnts;
        this.unitCost = uCost;
        this.associatedVariable = var;
        this.setVariable(var, this.amounts[0]);
    }

    public double getCost(int cropYear) {
        if (cropYear >= this.amounts.length) {
            throw new Error("No amount specified for " + (Object)((Object)this.associatedVariable) + " in year " + cropYear);
        }
        return this.amounts[cropYear] * this.unitCost;
    }

    public CropInput copy() {
        double[] newAmounts = new double[this.amounts.length];
        for (int i = 0; i < this.amounts.length; ++i) {
            newAmounts[i] = this.amounts[i];
        }
        return new CropInput(newAmounts, this.unitCost, this.associatedVariable);
    }

    public void setUnitCost(double c) {
        this.unitCost = c;
    }
}

